/*
 * Decompiled with CFR 0.152.
 */
package org.openscoring.service;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.dmg.pmml.PMML;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
@Singleton
public class ModelRegistry {
    private Map<String, PMML> models = Maps.newTreeMap((Comparator)new Comparator<String>(){

        @Override
        public int compare(String left, String right) {
            return left.compareToIgnoreCase(right);
        }
    });

    public Set<String> idSet() {
        return Collections.unmodifiableSet(this.models.keySet());
    }

    public PMML get(String id) {
        return this.models.get(id);
    }

    public PMML put(String id, InputStream is) throws SAXException, JAXBException {
        InputSource source = new InputSource(is);
        PMML pmml = JAXBUtil.unmarshalPMML((Source)ImportFilter.apply((InputSource)source));
        return this.put(id, pmml);
    }

    public PMML put(String id, PMML pmml) {
        return this.models.put(id, pmml);
    }

    public PMML remove(String id) {
        return this.models.remove(id);
    }
}

