/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.alerting.destination.message.BaseMessage;
import org.opensearch.alerting.destination.message.EmailMessage;

public class DestinationEmailClient {
    private static final Logger logger = LogManager.getLogger(DestinationEmailClient.class);

    public String execute(BaseMessage message) throws Exception {
        if (message instanceof EmailMessage) {
            final EmailMessage emailMessage = (EmailMessage)message;
            Session session = null;
            Properties prop = new Properties();
            prop.put("mail.transport.protocol", "smtp");
            prop.put("mail.smtp.host", emailMessage.getHost());
            prop.put("mail.smtp.port", (Object)emailMessage.getPort());
            if (emailMessage.getUsername() != null && !emailMessage.getUsername().equals((Object)"".toCharArray())) {
                prop.put("mail.smtp.auth", (Object)true);
                try {
                    session = Session.getInstance(prop, new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(emailMessage.getUsername().toString(), emailMessage.getPassword().toString());
                        }
                    });
                }
                catch (IllegalStateException e) {
                    return e.getMessage();
                }
            } else {
                session = Session.getInstance(prop);
            }
            switch (emailMessage.getMethod()) {
                case "ssl": {
                    prop.put("mail.smtp.ssl.enable", (Object)true);
                    break;
                }
                case "starttls": {
                    prop.put("mail.smtp.starttls.enable", (Object)true);
                }
            }
            try {
                MimeMessage mailmsg = new MimeMessage(session);
                ((Message)mailmsg).setFrom(new InternetAddress(emailMessage.getFrom()));
                ((Message)mailmsg).setRecipients(Message.RecipientType.TO, this.getRecipientsAsAddresses(emailMessage.getRecipients()));
                ((Message)mailmsg).setSubject(emailMessage.getSubject());
                mailmsg.setText(emailMessage.getMessageContent());
                this.SendMessage(mailmsg);
            }
            catch (MessagingException e) {
                throw new MessagingException(e.getMessage());
            }
        }
        return "Sent";
    }

    public void SendMessage(Message msg) throws Exception {
        Transport.send(msg);
    }

    private InternetAddress[] getRecipientsAsAddresses(List<String> recipients) throws Exception {
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (String recipient : recipients) {
            addresses.add(new InternetAddress(recipient));
        }
        return addresses.toArray(new InternetAddress[0]);
    }
}

