/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.client;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.alerting.destination.message.BaseMessage;
import org.opensearch.alerting.destination.message.CustomWebhookMessage;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.notification.repackage.org.apache.http.HttpEntity;
import org.opensearch.notification.repackage.org.apache.http.HttpResponse;
import org.opensearch.notification.repackage.org.apache.http.client.config.RequestConfig;
import org.opensearch.notification.repackage.org.apache.http.client.methods.CloseableHttpResponse;
import org.opensearch.notification.repackage.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.opensearch.notification.repackage.org.apache.http.client.methods.HttpPatch;
import org.opensearch.notification.repackage.org.apache.http.client.methods.HttpPost;
import org.opensearch.notification.repackage.org.apache.http.client.methods.HttpPut;
import org.opensearch.notification.repackage.org.apache.http.client.methods.HttpRequestBase;
import org.opensearch.notification.repackage.org.apache.http.entity.StringEntity;
import org.opensearch.notification.repackage.org.apache.http.impl.client.CloseableHttpClient;
import org.opensearch.notification.repackage.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.opensearch.notification.repackage.org.apache.http.impl.client.HttpClientBuilder;
import org.opensearch.notification.repackage.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.opensearch.notification.repackage.org.apache.http.util.EntityUtils;
import org.opensearch.rest.RestStatus;

public class DestinationHttpClient {
    private static final Logger logger = LogManager.getLogger(DestinationHttpClient.class);
    private static final int MAX_CONNECTIONS = 60;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 20;
    private static final int TIMEOUT_MILLISECONDS = (int)TimeValue.timeValueSeconds((long)5L).millis();
    private static final int SOCKET_TIMEOUT_MILLISECONDS = (int)TimeValue.timeValueSeconds((long)50L).millis();
    private static final Set<Integer> VALID_RESPONSE_STATUS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(RestStatus.OK.getStatus(), RestStatus.CREATED.getStatus(), RestStatus.ACCEPTED.getStatus(), RestStatus.NON_AUTHORITATIVE_INFORMATION.getStatus(), RestStatus.NO_CONTENT.getStatus(), RestStatus.RESET_CONTENT.getStatus(), RestStatus.PARTIAL_CONTENT.getStatus(), RestStatus.MULTI_STATUS.getStatus())));
    private static CloseableHttpClient HTTP_CLIENT = DestinationHttpClient.createHttpClient();

    private static CloseableHttpClient createHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(TIMEOUT_MILLISECONDS).setConnectionRequestTimeout(TIMEOUT_MILLISECONDS).setSocketTimeout(SOCKET_TIMEOUT_MILLISECONDS).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(60);
        connectionManager.setDefaultMaxPerRoute(20);
        return HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager(connectionManager).setRetryHandler(new DefaultHttpRequestRetryHandler()).useSystemProperties().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(BaseMessage message) throws Exception {
        CloseableHttpResponse response = null;
        try {
            response = this.getHttpResponse(message);
            this.validateResponseStatus(response);
            String string = this.getResponseString(response);
            return string;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
        }
    }

    private CloseableHttpResponse getHttpResponse(BaseMessage message) throws Exception {
        HttpRequestBase httpRequest;
        URI uri = null;
        if (message instanceof CustomWebhookMessage) {
            CustomWebhookMessage customWebhookMessage = (CustomWebhookMessage)message;
            uri = customWebhookMessage.getUri();
            httpRequest = this.constructHttpRequest(((CustomWebhookMessage)message).getMethod());
            Map<String, String> headerParams = customWebhookMessage.getHeaderParams();
            if (headerParams == null || headerParams.isEmpty()) {
                httpRequest.setHeader("Content-Type", "application/json");
            } else {
                for (Map.Entry<String, String> e : customWebhookMessage.getHeaderParams().entrySet()) {
                    httpRequest.setHeader(e.getKey(), e.getValue());
                }
            }
        } else {
            httpRequest = new HttpPost();
            uri = message.getUri();
        }
        httpRequest.setURI(uri);
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            StringEntity entity = new StringEntity(this.extractBody(message), StandardCharsets.UTF_8);
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
        }
        return HTTP_CLIENT.execute(httpRequest);
    }

    private HttpRequestBase constructHttpRequest(String method) {
        switch (method) {
            case "POST": {
                return new HttpPost();
            }
            case "PUT": {
                return new HttpPut();
            }
            case "PATCH": {
                return new HttpPatch();
            }
        }
        throw new IllegalArgumentException("Invalid method supplied");
    }

    public String getResponseString(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return "{}";
        }
        String responseString = EntityUtils.toString(entity);
        logger.debug("Http response: " + responseString);
        return responseString;
    }

    private void validateResponseStatus(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!VALID_RESPONSE_STATUS.contains(statusCode)) {
            throw new IOException("Failed: " + response);
        }
    }

    private String extractBody(BaseMessage message) {
        return message.getMessageContent();
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        HTTP_CLIENT = httpClient;
    }
}

