/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.factory;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.alerting.destination.client.DestinationHttpClient;
import org.opensearch.alerting.destination.client.DestinationHttpClientPool;
import org.opensearch.alerting.destination.factory.DestinationFactory;
import org.opensearch.alerting.destination.message.ChimeMessage;
import org.opensearch.alerting.destination.response.DestinationResponse;
import org.opensearch.rest.RestStatus;

public class ChimeDestinationFactory
implements DestinationFactory<ChimeMessage, DestinationHttpClient> {
    private static final Logger logger = LogManager.getLogger(ChimeDestinationFactory.class);
    private DestinationHttpClient destinationHttpClient = DestinationHttpClientPool.getHttpClient();

    public DestinationResponse publish(ChimeMessage message) {
        try {
            String response = this.getClient(message).execute(message);
            return new DestinationResponse.Builder().withStatusCode(RestStatus.OK.getStatus()).withResponseContent(response).build();
        }
        catch (Exception ex) {
            logger.error("Exception publishing Message: " + message.toString(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public DestinationHttpClient getClient(ChimeMessage message) {
        return this.destinationHttpClient;
    }

    public void setClient(DestinationHttpClient client) {
        this.destinationHttpClient = client;
    }
}

