/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.factory;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.alerting.destination.factory.ChimeDestinationFactory;
import org.opensearch.alerting.destination.factory.CustomWebhookDestinationFactory;
import org.opensearch.alerting.destination.factory.DestinationFactory;
import org.opensearch.alerting.destination.factory.EmailDestinationFactory;
import org.opensearch.alerting.destination.factory.SlackDestinationFactory;
import org.opensearch.alerting.destination.message.DestinationType;

public class DestinationFactoryProvider {
    private static Map<DestinationType, DestinationFactory> destinationFactoryMap = new HashMap<DestinationType, DestinationFactory>();

    public static DestinationFactory getFactory(DestinationType destinationType) {
        if (!destinationFactoryMap.containsKey((Object)destinationType)) {
            throw new IllegalArgumentException("Invalid channel type");
        }
        return destinationFactoryMap.get((Object)destinationType);
    }

    public static void setFactory(DestinationType type, DestinationFactory factory) {
        destinationFactoryMap.put(type, factory);
    }

    static {
        destinationFactoryMap.put(DestinationType.CHIME, new ChimeDestinationFactory());
        destinationFactoryMap.put(DestinationType.SLACK, new SlackDestinationFactory());
        destinationFactoryMap.put(DestinationType.CUSTOMWEBHOOK, new CustomWebhookDestinationFactory());
        destinationFactoryMap.put(DestinationType.EMAIL, new EmailDestinationFactory());
    }
}

