/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.message;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.opensearch.alerting.destination.message.DestinationType;
import org.opensearch.common.Strings;
import org.opensearch.notification.repackage.org.apache.http.client.utils.URIBuilder;

public abstract class BaseMessage {
    protected DestinationType destinationType;
    protected String destinationName;
    protected String url;
    private String content;

    BaseMessage(DestinationType destinationType, String destinationName, String content) {
        if (destinationType == null) {
            throw new IllegalArgumentException("Channel type must be defined");
        }
        if (!Strings.hasLength((String)destinationName)) {
            throw new IllegalArgumentException("Channel name must be defined");
        }
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.content = content;
    }

    BaseMessage(DestinationType destinationType, String destinationName, String content, String url) {
        this(destinationType, destinationName, content);
        if (url == null) {
            throw new IllegalArgumentException("url is invalid or empty");
        }
        this.url = url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DestinationType getChannelType() {
        return this.destinationType;
    }

    public String getChannelName() {
        return this.destinationName;
    }

    public String getMessageContent() {
        return this.content;
    }

    public String getUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.buildUri(this.getUrl().trim(), null, null, -1, null, null);
    }

    protected URI buildUri(String endpoint, String scheme, String host, int port, String path, Map<String, String> queryParams) {
        try {
            if (Strings.isNullOrEmpty((String)endpoint)) {
                if (Strings.isNullOrEmpty((String)scheme)) {
                    scheme = "https";
                }
                URIBuilder uriBuilder = new URIBuilder();
                if (queryParams != null) {
                    for (Map.Entry<String, String> e : queryParams.entrySet()) {
                        uriBuilder.addParameter(e.getKey(), e.getValue());
                    }
                }
                return uriBuilder.setScheme(scheme).setHost(host).setPort(port).setPath(path).build();
            }
            return new URIBuilder(endpoint).build();
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException("Error creating URI");
        }
    }
}

