/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.message;

import java.net.URI;
import java.util.Map;
import org.opensearch.alerting.destination.message.BaseMessage;
import org.opensearch.alerting.destination.message.DestinationType;
import org.opensearch.common.Strings;

public class CustomWebhookMessage
extends BaseMessage {
    private String message;
    private String url;
    private String scheme;
    private String host;
    private String method;
    private int port;
    private String path;
    private Map<String, String> queryParams;
    private Map<String, String> headerParams;
    private final String userName;
    private final String password;

    private CustomWebhookMessage(DestinationType destinationType, String destinationName, String url, String scheme, String host, Integer port, String path, String method, Map<String, String> queryParams, Map<String, String> headerParams, String userName, String password, String message) {
        super(destinationType, destinationName, message);
        if (DestinationType.CUSTOMWEBHOOK != destinationType) {
            throw new IllegalArgumentException("Channel Type does not match CustomWebhook");
        }
        if (!Strings.isNullOrEmpty((String)url)) {
            this.setUrl(url.trim());
        }
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        this.scheme = Strings.isNullOrEmpty((String)scheme) ? "https" : scheme;
        int n = this.port = port == null ? -1 : port;
        if (!Strings.isNullOrEmpty((String)path) && !path.startsWith("/")) {
            this.path = "/" + path;
        }
        if (Strings.isNullOrEmpty((String)url) && Strings.isNullOrEmpty((String)host)) {
            throw new IllegalArgumentException("Either fully qualified URL or host name should be provided");
        }
        if (Strings.isNullOrEmpty((String)method)) {
            this.method = "POST";
        } else {
            if (!("POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method))) {
                throw new IllegalArgumentException("Invalid method supplied. Only POST, PUT and PATCH are allowed");
            }
            this.method = method;
        }
        this.message = message;
        this.url = url;
        this.host = host;
        this.queryParams = queryParams;
        this.headerParams = headerParams;
        this.userName = userName;
        this.password = password;
    }

    public String toString() {
        return "DestinationType: " + (Object)((Object)this.destinationType) + ", DestinationName:" + this.destinationName + ", Url: " + this.url + ", scheme: " + this.scheme + ", Host: " + this.host + ", Port: " + this.port + ", Path: " + this.path + ", Method: " + this.method + ", Message: " + this.message;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaderParams() {
        return this.headerParams;
    }

    @Override
    public URI getUri() {
        return this.buildUri(this.getUrl(), this.getScheme(), this.getHost(), this.getPort(), this.getPath(), this.getQueryParams());
    }

    public static class Builder {
        private String message;
        private DestinationType destinationType;
        private String destinationName;
        private String url;
        private String scheme;
        private String host;
        private Integer port;
        private String path;
        private String method;
        private Map<String, String> queryParams;
        private Map<String, String> headerParams;
        private String userName;
        private String password;

        public Builder(String destinationName) {
            this.destinationName = destinationName;
            this.destinationType = DestinationType.CUSTOMWEBHOOK;
        }

        public Builder withScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withQueryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder withHeaderParams(Map<String, String> headerParams) {
            this.headerParams = headerParams;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public CustomWebhookMessage build() {
            CustomWebhookMessage customWebhookMessage = new CustomWebhookMessage(this.destinationType, this.destinationName, this.url, this.scheme, this.host, this.port, this.path, this.method, this.queryParams, this.headerParams, this.userName, this.password, this.message);
            return customWebhookMessage;
        }
    }
}

