/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.message;

import java.net.URI;
import java.util.List;
import org.opensearch.alerting.destination.message.BaseMessage;
import org.opensearch.alerting.destination.message.DestinationType;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.SecureString;

public class EmailMessage
extends BaseMessage {
    private String message;
    private String host;
    private int port;
    private String method;
    private String from;
    private List<String> recipients;
    private String subject;
    private final SecureString username;
    private final SecureString password;

    private EmailMessage(DestinationType destinationType, String destinationName, String host, Integer port, String method, String from, List<String> recipients, String subject, SecureString username, SecureString password, String message) {
        super(destinationType, destinationName, message);
        if (DestinationType.EMAIL != destinationType) {
            throw new IllegalArgumentException("Channel Type does not match Email");
        }
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        if (Strings.isNullOrEmpty((String)host)) {
            throw new IllegalArgumentException("Host name should be provided");
        }
        if (Strings.isNullOrEmpty((String)from)) {
            throw new IllegalArgumentException("From address should be provided");
        }
        if (recipients == null || recipients.isEmpty()) {
            throw new IllegalArgumentException("List of recipients should be provided");
        }
        this.message = message;
        this.host = host;
        this.port = port == null ? 25 : port;
        this.method = method == null ? "none" : method;
        this.from = from;
        this.recipients = recipients;
        this.subject = subject == "" ? destinationName : subject;
        this.username = username;
        this.password = password;
    }

    public String toString() {
        return "DestinationType: " + (Object)((Object)this.destinationType) + ", DestinationName: " + this.destinationName + ", Host: " + this.host + ", Port: " + this.port + ", Message: " + this.message;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getMethod() {
        return this.method;
    }

    public String getFrom() {
        return this.from;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public SecureString getUsername() {
        return this.username;
    }

    public SecureString getPassword() {
        return this.password;
    }

    @Override
    public URI getUri() {
        return this.buildUri(null, null, this.host, this.port, null, null);
    }

    public static class Builder {
        private String message;
        private DestinationType destinationType;
        private String destinationName;
        private String host;
        private Integer port;
        private String method;
        private String from;
        private List<String> recipients;
        private String subject;
        private SecureString username;
        private SecureString password;

        public Builder(String destinationName) {
            this.destinationName = destinationName;
            this.destinationType = DestinationType.EMAIL;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder withRecipients(List<String> recipients) {
            this.recipients = recipients;
            return this;
        }

        public Builder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUserName(SecureString username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(SecureString password) {
            this.password = password;
            return this;
        }

        public EmailMessage build() {
            return new EmailMessage(this.destinationType, this.destinationName, this.host, this.port, this.method, this.from, this.recipients, this.subject, this.username, this.password, this.message);
        }
    }
}

