/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.destination.message;

import org.opensearch.alerting.destination.message.BaseMessage;
import org.opensearch.alerting.destination.message.DestinationType;
import org.opensearch.common.Strings;

public class SlackMessage
extends BaseMessage {
    private String message;

    private SlackMessage(DestinationType destinationType, String destinationName, String url, String message) {
        super(destinationType, destinationName, message, url);
        if (DestinationType.SLACK != destinationType) {
            throw new IllegalArgumentException("Channel Type does not match Slack");
        }
        if (Strings.isNullOrEmpty((String)url)) {
            throw new IllegalArgumentException("Fully qualified URL is missing/invalid: " + url);
        }
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        this.message = message;
    }

    public String toString() {
        return "DestinationType: " + (Object)((Object)this.destinationType) + ", DestinationName:" + this.destinationName + ", Url: " + this.url + ", Message: " + this.message;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public static class Builder {
        private String message;
        private DestinationType destinationType;
        private String destinationName;
        private String url;

        public Builder(String channelName) {
            this.destinationName = channelName;
            this.destinationType = DestinationType.SLACK;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public SlackMessage build() {
            SlackMessage slackMessage = new SlackMessage(this.destinationType, this.destinationName, this.url, this.message);
            return slackMessage;
        }
    }
}

