/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.Constants;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.opensearch.Build;
import org.opensearch.Version;
import org.opensearch.bootstrap.JarHell;
import org.opensearch.cli.EnvironmentAwareCommand;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.hash.MessageDigests;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.env.Environment;
import org.opensearch.plugins.Platforms;
import org.opensearch.plugins.PluginHelper;
import org.opensearch.plugins.PluginInfo;
import org.opensearch.plugins.PluginSecurity;
import org.opensearch.plugins.PluginsService;
import org.opensearch.plugins.ProgressInputStream;

class InstallPluginCommand
extends EnvironmentAwareCommand {
    private static final String PROPERTY_STAGING_ID = "opensearch.plugins.staging";
    static final int PLUGIN_EXISTS = 1;
    static final int PLUGIN_MALFORMED = 2;
    static final Set<String> MODULES;
    static final Set<String> OFFICIAL_PLUGINS;
    private final OptionSpec<Void> batchOption;
    private final OptionSpec<String> arguments;
    static final Set<PosixFilePermission> BIN_DIR_PERMS;
    static final Set<PosixFilePermission> BIN_FILES_PERMS;
    static final Set<PosixFilePermission> CONFIG_DIR_PERMS;
    static final Set<PosixFilePermission> CONFIG_FILES_PERMS;
    static final Set<PosixFilePermission> PLUGIN_DIR_PERMS;
    static final Set<PosixFilePermission> PLUGIN_FILES_PERMS;
    private static final String LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR;
    private final List<Path> pathsToDeleteOnShutdown = new ArrayList<Path>();

    InstallPluginCommand() {
        super("Install a plugin");
        this.batchOption = this.parser.acceptsAll(Arrays.asList("b", "batch"), "Enable batch mode explicitly, automatic confirmation of security permission");
        this.arguments = this.parser.nonOptions("plugin id");
    }

    protected void printAdditionalHelp(Terminal terminal) {
        terminal.println("The following official plugins may be installed by name:");
        for (String plugin : OFFICIAL_PLUGINS) {
            terminal.println("  " + plugin);
        }
        terminal.println("");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        List pluginId = this.arguments.values(options);
        boolean isBatch = options.has(this.batchOption);
        this.execute(terminal, pluginId, isBatch, env);
    }

    void execute(Terminal terminal, List<String> pluginIds, boolean isBatch, Environment env) throws Exception {
        if (pluginIds.isEmpty()) {
            throw new UserException(64, "at least one plugin id is required");
        }
        HashSet<String> uniquePluginIds = new HashSet<String>();
        for (String pluginId : pluginIds) {
            if (uniquePluginIds.add(pluginId)) continue;
            throw new UserException(64, "duplicate plugin id [" + pluginId + "]");
        }
        LinkedHashMap<String, ArrayList<Path>> deleteOnFailures = new LinkedHashMap<String, ArrayList<Path>>();
        for (String pluginId : pluginIds) {
            terminal.println("-> Installing " + pluginId);
            try {
                ArrayList<Path> deleteOnFailure = new ArrayList<Path>();
                deleteOnFailures.put(pluginId, deleteOnFailure);
                Path pluginZip = this.download(terminal, pluginId, env.tmpFile(), isBatch);
                Path extractedZip = this.unzip(pluginZip, env.pluginsFile());
                deleteOnFailure.add(extractedZip);
                PluginInfo pluginInfo = this.installPlugin(terminal, isBatch, extractedZip, env, deleteOnFailure);
                terminal.println("-> Installed " + pluginInfo.getName() + " with folder name " + pluginInfo.getTargetFolderName());
                deleteOnFailures.remove(pluginId);
                deleteOnFailures.put(pluginInfo.getName(), deleteOnFailure);
            }
            catch (Exception installProblem) {
                terminal.println("-> Failed installing " + pluginId);
                for (Map.Entry deleteOnFailureEntry : deleteOnFailures.entrySet()) {
                    terminal.println("-> Rolling back " + (String)deleteOnFailureEntry.getKey());
                    boolean success = false;
                    try {
                        IOUtils.rm((Path[])((List)deleteOnFailureEntry.getValue()).toArray(new Path[0]));
                        success = true;
                    }
                    catch (IOException exceptionWhileRemovingFiles) {
                        Exception exception = new Exception("failed rolling back installation of [" + (String)deleteOnFailureEntry.getKey() + "]", exceptionWhileRemovingFiles);
                        installProblem.addSuppressed(exception);
                        terminal.println("-> Failed rolling back " + (String)deleteOnFailureEntry.getKey());
                    }
                    if (!success) continue;
                    terminal.println("-> Rolled back " + (String)deleteOnFailureEntry.getKey());
                }
                throw installProblem;
            }
        }
    }

    private Path download(Terminal terminal, String pluginId, Path tmpDir, boolean isBatch) throws Exception {
        if (OFFICIAL_PLUGINS.contains(pluginId)) {
            String url = this.getOpenSearchUrl(terminal, this.getStagingHash(), Version.CURRENT, this.isSnapshot(), pluginId, Platforms.PLATFORM_NAME);
            terminal.println("-> Downloading " + pluginId + " from opensearch");
            return this.downloadAndValidate(terminal, url, tmpDir, true, isBatch);
        }
        String[] coordinates = pluginId.split(":");
        if (coordinates.length == 3 && !pluginId.contains("/") && !pluginId.startsWith("file:")) {
            String mavenUrl = this.getMavenUrl(terminal, coordinates, Platforms.PLATFORM_NAME);
            terminal.println("-> Downloading " + pluginId + " from maven central");
            return this.downloadAndValidate(terminal, mavenUrl, tmpDir, false, isBatch);
        }
        if (!pluginId.contains(":")) {
            List<String> plugins = this.checkMisspelledPlugin(pluginId);
            String msg = "Unknown plugin " + pluginId;
            if (!plugins.isEmpty()) {
                msg = msg + ", did you mean " + (plugins.size() == 1 ? "[" + plugins.get(0) + "]" : "any of " + plugins.toString()) + "?";
            }
            throw new UserException(64, msg);
        }
        terminal.println("-> Downloading " + URLDecoder.decode(pluginId, "UTF-8"));
        return this.downloadZip(terminal, pluginId, tmpDir, isBatch);
    }

    String getStagingHash() {
        return System.getProperty(PROPERTY_STAGING_ID);
    }

    boolean isSnapshot() {
        return Build.CURRENT.isSnapshot();
    }

    private String getOpenSearchUrl(Terminal terminal, String stagingHash, Version version, boolean isSnapshot, String pluginId, String platform) throws IOException, UserException {
        if (isSnapshot && stagingHash == null) {
            throw new UserException(78, "attempted to install release build of official plugin on snapshot build of OpenSearch");
        }
        String baseUrl = stagingHash != null ? String.format(Locale.ROOT, "https://artifacts.opensearch.org/snapshots/plugins/%s/%s-%s", pluginId, version, stagingHash) : String.format(Locale.ROOT, "https://artifacts.opensearch.org/releases/plugins/%s/%s", pluginId, version);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, pluginId, platform, Build.CURRENT.getQualifiedVersion());
        if (this.urlExists(terminal, platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, pluginId, Build.CURRENT.getQualifiedVersion());
    }

    private String getMavenUrl(Terminal terminal, String[] coordinates, String platform) throws IOException {
        String groupId = coordinates[0].replace(".", "/");
        String artifactId = coordinates[1];
        String version = coordinates[2];
        String baseUrl = String.format(Locale.ROOT, "https://repo1.maven.org/maven2/%s/%s/%s", groupId, artifactId, version);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, artifactId, platform, version);
        if (this.urlExists(terminal, platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, artifactId, version);
    }

    @SuppressForbidden(reason="Make HEAD request using URLConnection.connect()")
    boolean urlExists(Terminal terminal, String urlString) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Checking if url exists: " + urlString);
        URL url = new URL(urlString);
        assert ("https".equals(url.getProtocol())) : "Only http urls can be checked";
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "opensearch-plugin-installer");
        urlConnection.setRequestMethod("HEAD");
        urlConnection.connect();
        return urlConnection.getResponseCode() == 200;
    }

    private List<String> checkMisspelledPlugin(String pluginId) {
        LevenshteinDistance ld = new LevenshteinDistance();
        ArrayList<Tuple> scoredKeys = new ArrayList<Tuple>();
        for (String officialPlugin : OFFICIAL_PLUGINS) {
            float distance = ld.getDistance(pluginId, officialPlugin);
            if (!(distance > 0.7f)) continue;
            scoredKeys.add(new Tuple((Object)Float.valueOf(distance), (Object)officialPlugin));
        }
        CollectionUtil.timSort(scoredKeys, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredKeys.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
    }

    @SuppressForbidden(reason="We use getInputStream to download plugins")
    Path downloadZip(Terminal terminal, String urlString, Path tmpDir, boolean isBatch) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Retrieving zip from " + urlString);
        URL url = new URL(urlString);
        Path zip = Files.createTempFile(tmpDir, null, ".zip", new FileAttribute[0]);
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "opensearch-plugin-installer");
        try (InputStream in = isBatch ? urlConnection.getInputStream() : new TerminalProgressInputStream(urlConnection.getInputStream(), urlConnection.getContentLength(), terminal);){
            Files.copy(in, zip, StandardCopyOption.REPLACE_EXISTING);
        }
        return zip;
    }

    @SuppressForbidden(reason="URL#openStream")
    private InputStream urlOpenStream(URL url) throws IOException {
        return url.openStream();
    }

    private Path downloadAndValidate(Terminal terminal, String urlString, Path tmpDir, boolean officialPlugin, boolean isBatch) throws IOException, PGPException, UserException {
        String expectedChecksum;
        Path zip = this.downloadZip(terminal, urlString, tmpDir, isBatch);
        this.pathsToDeleteOnShutdown.add(zip);
        String checksumUrlString = urlString + ".sha512";
        URL checksumUrl = this.openUrl(checksumUrlString);
        String digestAlgo = "SHA-512";
        if (checksumUrl == null && !officialPlugin) {
            terminal.println("Warning: sha512 not found, falling back to sha1. This behavior is deprecated and will be removed in a future release. Please update the plugin to use a sha512 checksum.");
            checksumUrlString = urlString + ".sha1";
            checksumUrl = this.openUrl(checksumUrlString);
            digestAlgo = "SHA-1";
        }
        if (checksumUrl == null) {
            throw new UserException(74, "Plugin checksum missing: " + checksumUrlString);
        }
        try (InputStream in = this.urlOpenStream(checksumUrl);){
            BufferedReader checksumReader;
            if (digestAlgo.equals("SHA-1")) {
                checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                expectedChecksum = checksumReader.readLine();
                if (checksumReader.readLine() != null) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
            } else {
                String[] segments;
                String expectedFile;
                checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                String checksumLine = checksumReader.readLine();
                String[] fields = checksumLine.split(" {2}");
                if (officialPlugin && fields.length != 2 || !officialPlugin && fields.length > 2) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
                expectedChecksum = fields[0];
                if (fields.length == 2 && !fields[1].equals(expectedFile = (segments = URI.create(urlString).getPath().split("/"))[segments.length - 1])) {
                    String message = String.format(Locale.ROOT, "checksum file at [%s] is not for this plugin, expected [%s] but was [%s]", checksumUrl, expectedFile, fields[1]);
                    throw new UserException(74, message);
                }
                if (checksumReader.readLine() != null) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
            }
        }
        try (InputStream zis = Files.newInputStream(zip, new OpenOption[0]);){
            try {
                int read;
                MessageDigest digest = MessageDigest.getInstance(digestAlgo);
                byte[] bytes = new byte[8192];
                while ((read = zis.read(bytes)) != -1) {
                    assert (read > 0) : read;
                    digest.update(bytes, 0, read);
                }
                String actualChecksum = MessageDigests.toHexString((byte[])digest.digest());
                if (!expectedChecksum.equals(actualChecksum)) {
                    throw new UserException(74, digestAlgo + " mismatch, expected " + expectedChecksum + " but got " + actualChecksum);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (officialPlugin) {
            this.verifySignature(zip, urlString);
        }
        return zip;
    }

    void verifySignature(Path zip, String urlString) throws IOException, PGPException {
        String sigUrlString = urlString + ".sig";
        URL sigUrl = this.openUrl(sigUrlString);
        try (InputStream fin = this.pluginZipInputStream(zip);
             InputStream sin = this.urlOpenStream(sigUrl);
             ArmoredInputStream ain = new ArmoredInputStream(this.getPublicKey());){
            int read;
            JcaPGPObjectFactory factory = new JcaPGPObjectFactory(PGPUtil.getDecoderStream((InputStream)sin));
            PGPSignature signature = ((PGPSignatureList)factory.nextObject()).get(0);
            String keyId = Long.toHexString(signature.getKeyID()).toUpperCase(Locale.ROOT);
            if (!this.getPublicKeyId().equals(keyId)) {
                throw new IllegalStateException("key id [" + keyId + "] does not match expected key id [" + this.getPublicKeyId() + "]");
            }
            PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection((InputStream)ain, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey key = collection.getPublicKey(signature.getKeyID());
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)new BouncyCastleFipsProvider()), key);
            byte[] buffer = new byte[1024];
            while ((read = fin.read(buffer)) != -1) {
                signature.update(buffer, 0, read);
            }
            if (!signature.verify()) {
                throw new IllegalStateException("signature verification for [" + urlString + "] failed");
            }
        }
    }

    InputStream pluginZipInputStream(Path zip) throws IOException {
        return Files.newInputStream(zip, new OpenOption[0]);
    }

    String getPublicKeyId() {
        return "C2EE2AF6542C03B4";
    }

    InputStream getPublicKey() {
        return InstallPluginCommand.class.getResourceAsStream("/public_key.sig");
    }

    URL openUrl(String urlString) throws IOException {
        URL checksumUrl = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)checksumUrl.openConnection();
        if (connection.getResponseCode() == 404) {
            return null;
        }
        return checksumUrl;
    }

    private Path unzip(Path zip, Path pluginsDir) throws IOException, UserException {
        Path target = this.stagingDirectory(pluginsDir);
        this.pathsToDeleteOnShutdown.add(target);
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInput.getNextEntry()) != null) {
                if (entry.getName().startsWith("opensearch/")) {
                    throw new UserException(2, "This plugin was built with an older plugin structure. Contact the plugin author to remove the intermediate \"opensearch\" directory within the plugin zip.");
                }
                Path targetFile = target.resolve(entry.getName());
                if (!targetFile.normalize().startsWith(target)) {
                    throw new UserException(2, "Zip contains entry name '" + entry.getName() + "' resolving outside of plugin directory");
                }
                if (!Files.isSymbolicLink(targetFile.getParent())) {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
                        int len;
                        while ((len = zipInput.read(buffer)) >= 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                }
                zipInput.closeEntry();
            }
        }
        catch (UserException e) {
            IOUtils.rm((Path[])new Path[]{target});
            throw e;
        }
        Files.delete(zip);
        return target;
    }

    private Path stagingDirectory(Path pluginsDir) throws IOException {
        try {
            return Files.createTempDirectory(pluginsDir, ".installing-", PosixFilePermissions.asFileAttribute(PLUGIN_DIR_PERMS));
        }
        catch (IllegalArgumentException e) {
            StackTraceElement[] elements = e.getStackTrace();
            if (elements.length >= 1 && elements[0].getClassName().equals("com.google.common.jimfs.AttributeService") && elements[0].getMethodName().equals("setAttributeInternal")) {
                return this.stagingDirectoryWithoutPosixPermissions(pluginsDir);
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            return this.stagingDirectoryWithoutPosixPermissions(pluginsDir);
        }
    }

    private Path stagingDirectoryWithoutPosixPermissions(Path pluginsDir) throws IOException {
        return Files.createTempDirectory(pluginsDir, ".installing-", new FileAttribute[0]);
    }

    private void verifyPluginName(Path pluginPath, String pluginName) throws UserException, IOException {
        if (MODULES.contains(pluginName)) {
            throw new UserException(64, "plugin '" + pluginName + "' cannot be installed as a plugin, it is a system module");
        }
        Path destination = PluginHelper.verifyIfPluginExists(pluginPath, pluginName);
        if (Files.exists(destination, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "plugin directory [%s] already exists; if you need to update the plugin, uninstall it first using command 'remove %s'", destination, pluginName);
            throw new UserException(1, message);
        }
    }

    private PluginInfo loadPluginInfo(Terminal terminal, Path pluginRoot, Environment env) throws Exception {
        PluginInfo info = PluginInfo.readFromProperties((Path)pluginRoot);
        if (info.hasNativeController()) {
            throw new IllegalStateException("plugins can not have native controllers");
        }
        PluginsService.verifyCompatibility((PluginInfo)info);
        this.verifyPluginName(env.pluginsFile(), info.getName());
        PluginsService.checkForFailedPluginRemovals((Path)env.pluginsFile());
        terminal.println(Terminal.Verbosity.VERBOSE, info.toString());
        this.jarHellCheck(info, pluginRoot, env.pluginsFile(), env.modulesFile());
        return info;
    }

    void jarHellCheck(PluginInfo candidateInfo, Path candidateDir, Path pluginsDir, Path modulesDir) throws Exception {
        Set classpath = JarHell.parseClassPath().stream().filter(url -> {
            try {
                return !url.toURI().getPath().matches(LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR);
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }).collect(Collectors.toSet());
        HashSet<PluginsService.Bundle> bundles = new HashSet<PluginsService.Bundle>(PluginsService.getPluginBundles((Path)pluginsDir));
        bundles.addAll(PluginsService.getModuleBundles((Path)modulesDir));
        bundles.add(new PluginsService.Bundle(candidateInfo, candidateDir));
        List sortedBundles = PluginsService.sortBundles(bundles);
        HashMap transitiveUrls = new HashMap();
        for (PluginsService.Bundle bundle : sortedBundles) {
            PluginsService.checkBundleJarHell(classpath, (PluginsService.Bundle)bundle, transitiveUrls);
        }
    }

    private PluginInfo installPlugin(Terminal terminal, boolean isBatch, Path tmpRoot, Environment env, List<Path> deleteOnFailure) throws Exception {
        PluginInfo info = this.loadPluginInfo(terminal, tmpRoot, env);
        Path policy = tmpRoot.resolve("plugin-security.policy");
        Set permissions = Files.exists(policy, new LinkOption[0]) ? PluginSecurity.parsePermissions((Path)policy, (Path)env.tmpFile()) : Collections.emptySet();
        PluginSecurity.confirmPolicyExceptions((Terminal)terminal, (Set)permissions, (boolean)isBatch);
        String targetFolderName = info.getTargetFolderName();
        Path destination = env.pluginsFile().resolve(targetFolderName);
        deleteOnFailure.add(destination);
        this.installPluginSupportFiles(info, tmpRoot, env.binFile().resolve(targetFolderName), env.configFile().resolve(targetFolderName), deleteOnFailure);
        this.movePlugin(tmpRoot, destination);
        return info;
    }

    private void installPluginSupportFiles(PluginInfo info, Path tmpRoot, Path destBinDir, Path destConfigDir, List<Path> deleteOnFailure) throws Exception {
        Path tmpConfigDir;
        Path tmpBinDir = tmpRoot.resolve("bin");
        if (Files.exists(tmpBinDir, new LinkOption[0])) {
            deleteOnFailure.add(destBinDir);
            this.installBin(info, tmpBinDir, destBinDir);
        }
        if (Files.exists(tmpConfigDir = tmpRoot.resolve("config"), new LinkOption[0])) {
            this.installConfig(info, tmpConfigDir, destConfigDir);
        }
    }

    private void movePlugin(Path tmpRoot, Path destination) throws IOException {
        Files.move(tmpRoot, destination, StandardCopyOption.ATOMIC_MOVE);
        Files.walkFileTree(destination, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String parentDirName = file.getParent().getFileName().toString();
                if ("bin".equals(parentDirName) || Constants.MAC_OS_X && "MacOS".equals(parentDirName)) {
                    InstallPluginCommand.setFileAttributes(file, BIN_FILES_PERMS);
                } else {
                    InstallPluginCommand.setFileAttributes(file, PLUGIN_FILES_PERMS);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                InstallPluginCommand.setFileAttributes(dir, PLUGIN_DIR_PERMS);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void installBin(PluginInfo info, Path tmpBinDir, Path destBinDir) throws Exception {
        if (!Files.isDirectory(tmpBinDir, new LinkOption[0])) {
            throw new UserException(2, "bin in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destBinDir, new FileAttribute[0]);
        InstallPluginCommand.setFileAttributes(destBinDir, BIN_DIR_PERMS);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpBinDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in bin dir for plugin " + info.getName() + ", found " + srcFile.getFileName());
                }
                Path destFile = destBinDir.resolve(tmpBinDir.relativize(srcFile));
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginCommand.setFileAttributes(destFile, BIN_FILES_PERMS);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpBinDir});
    }

    private void installConfig(PluginInfo info, Path tmpConfigDir, Path destConfigDir) throws Exception {
        PosixFileAttributes destConfigDirAttributes;
        if (!Files.isDirectory(tmpConfigDir, new LinkOption[0])) {
            throw new UserException(2, "config in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destConfigDir, new FileAttribute[0]);
        InstallPluginCommand.setFileAttributes(destConfigDir, CONFIG_DIR_PERMS);
        PosixFileAttributeView destConfigDirAttributesView = Files.getFileAttributeView(destConfigDir.getParent(), PosixFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributes posixFileAttributes = destConfigDirAttributes = destConfigDirAttributesView != null ? destConfigDirAttributesView.readAttributes() : null;
        if (destConfigDirAttributes != null) {
            InstallPluginCommand.setOwnerGroup(destConfigDir, destConfigDirAttributes);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpConfigDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in config dir for plugin " + info.getName());
                }
                Path destFile = destConfigDir.resolve(tmpConfigDir.relativize(srcFile));
                if (Files.exists(destFile, new LinkOption[0])) continue;
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginCommand.setFileAttributes(destFile, CONFIG_FILES_PERMS);
                if (destConfigDirAttributes == null) continue;
                InstallPluginCommand.setOwnerGroup(destFile, destConfigDirAttributes);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpConfigDir});
    }

    private static void setOwnerGroup(Path path, PosixFileAttributes attributes) throws IOException {
        Objects.requireNonNull(attributes);
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        assert (fileAttributeView != null);
        fileAttributeView.setOwner(attributes.owner());
        fileAttributeView.setGroup(attributes.group());
    }

    private static void setFileAttributes(Path path, Set<PosixFilePermission> permissions) throws IOException {
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView != null) {
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    public void close() throws IOException {
        IOUtils.rm((Path[])this.pathsToDeleteOnShutdown.toArray(new Path[this.pathsToDeleteOnShutdown.size()]));
    }

    static {
        String line;
        BufferedReader reader;
        InputStream stream;
        try {
            stream = InstallPluginCommand.class.getResourceAsStream("/modules.txt");
            try {
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    HashSet<String> modules = new HashSet<String>();
                    line = reader.readLine();
                    while (line != null) {
                        modules.add(line.trim());
                        line = reader.readLine();
                    }
                    MODULES = Collections.unmodifiableSet(modules);
                }
                finally {
                    reader.close();
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            stream = InstallPluginCommand.class.getResourceAsStream("/plugins.txt");
            try {
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    TreeSet<String> plugins = new TreeSet<String>();
                    line = reader.readLine();
                    while (line != null) {
                        plugins.add(line.trim());
                        line = reader.readLine();
                    }
                    OFFICIAL_PLUGINS = Collections.unmodifiableSet(plugins);
                }
                finally {
                    reader.close();
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BIN_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-xr-x"));
        BIN_FILES_PERMS = BIN_DIR_PERMS;
        CONFIG_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
        CONFIG_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-rw----"));
        PLUGIN_DIR_PERMS = BIN_DIR_PERMS;
        PLUGIN_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r--r--"));
        LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR = String.format(Locale.ROOT, ".+%1$slib%1$stools%1$splugin-cli%1$s[^%1$s]+\\.jar", "(/|\\\\)");
    }

    private class TerminalProgressInputStream
    extends ProgressInputStream {
        private final Terminal terminal;
        private int width;
        private final boolean enabled;

        TerminalProgressInputStream(InputStream is, int expectedTotalSize, Terminal terminal) {
            super(is, expectedTotalSize);
            this.width = 50;
            this.terminal = terminal;
            this.enabled = expectedTotalSize > 0;
        }

        @Override
        public void onProgress(int percent) {
            if (this.enabled) {
                int currentPosition = percent * this.width / 100;
                StringBuilder sb = new StringBuilder("\r[");
                sb.append(String.join((CharSequence)"=", Collections.nCopies(currentPosition, "")));
                if (currentPosition > 0 && percent < 100) {
                    sb.append(">");
                }
                sb.append(String.join((CharSequence)" ", Collections.nCopies(this.width - currentPosition, "")));
                sb.append("] %s\u00a0\u00a0 ");
                if (percent == 100) {
                    sb.append("\n");
                }
                this.terminal.print(Terminal.Verbosity.NORMAL, String.format(Locale.ROOT, sb.toString(), percent + "%"));
            }
        }
    }
}

