/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.flow.schedule;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensingular.flow.schedule.IScheduleData;
import org.opensingular.flow.schedule.ScheduleDataImpl;

public class ScheduleDataBuilder {
    private ScheduleDataBuilder() {
    }

    public static IScheduleData buildMinutely(int minutes) {
        String description = "Repetido a cada " + minutes + "m";
        String cronExpression = ScheduleDataBuilder.generateCronExpression("0", "0/" + Integer.toString(minutes), "*", "*", "*", "?", "");
        return new ScheduleDataImpl(cronExpression, description);
    }

    public static IScheduleData buildHourly(int hours) {
        String description = "Repetido a cada " + hours + "h";
        String cronExpression = ScheduleDataBuilder.generateCronExpression("0", "0", "0/" + Integer.toString(hours), "*", "*", "?", "");
        return new ScheduleDataImpl(cronExpression, description);
    }

    public static IScheduleData buildDaily(int hours, int minutes) {
        String description = "Di\u00e1rio \u00e0s " + hours + ':' + (minutes < 10 ? "0" : "") + minutes + "h";
        String cronExpression = ScheduleDataBuilder.generateCronExpression("0", Integer.toString(minutes), Integer.toString(hours), "*", "*", "?", "");
        return new ScheduleDataImpl(cronExpression, description);
    }

    /*
     * Exception decompiling
     */
    public static IScheduleData buildWeekly(int hours, int minutes, Integer ... dayOfWeek) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IScheduleData buildMonthly(int dayOfMonth, int hours, int minutes, Integer ... months) {
        if (months.length == 0) {
            String description = "Mensal: todo dia " + dayOfMonth + " \u00e0s " + hours + ':' + (minutes < 10 ? "0" : "") + minutes + "h";
            String cronExpression = ScheduleDataBuilder.generateCronExpression("0", Integer.toString(minutes), Integer.toString(hours), Integer.toString(dayOfMonth), "*", "?", "");
            return new ScheduleDataImpl(cronExpression, description);
        }
        try (Stream<Integer> stream = Arrays.stream(months);){
            String monthsDescription = stream.map(Object::toString).collect(Collectors.joining(","));
            String description = "Mensal: todo dia " + dayOfMonth + " \u00e0s " + hours + ':' + (minutes < 10 ? "0" : "") + minutes + "h" + " nos meses: " + monthsDescription;
            String cronExpression = ScheduleDataBuilder.generateCronExpression("0", Integer.toString(minutes), Integer.toString(hours), Integer.toString(dayOfMonth), monthsDescription, "?", "");
            ScheduleDataImpl scheduleDataImpl = new ScheduleDataImpl(cronExpression, description);
            return scheduleDataImpl;
        }
    }

    private static String generateCronExpression(String seconds, String minutes, String hours, String dayOfMonth, String month, String dayOfWeek, String year) {
        return String.format("%1$s %2$s %3$s %4$s %5$s %6$s %7$s", seconds, minutes, hours, dayOfMonth, month, dayOfWeek, year).trim();
    }

    private static /* synthetic */ String lambda$buildWeekly$0(String[] weekDaysNames, Integer day) {
        return weekDaysNames[day];
    }
}

