/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.flow.schedule;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.opensingular.flow.schedule.IScheduleData;
import org.opensingular.flow.schedule.IScheduledJob;

public class ScheduledJob
implements IScheduledJob {
    private final String id;
    private final Supplier<Object> job;
    private final IScheduleData scheduleData;

    public ScheduledJob(String id, IScheduleData scheduleData, Supplier<Object> job) {
        this.id = id;
        this.job = job;
        this.scheduleData = scheduleData;
    }

    @Override
    public Object run() {
        Preconditions.checkNotNull(this.job, (Object)"Job implementation not provided.");
        return this.job.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IScheduleData getScheduleData() {
        return this.scheduleData;
    }

    public String toString() {
        return "ScheduledJob [job=" + this.getId() + ", scheduleData=" + this.scheduleData + "]";
    }
}

