/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.flow.schedule.quartz;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.opensingular.flow.schedule.IScheduleService;
import org.opensingular.flow.schedule.IScheduledJob;
import org.opensingular.flow.schedule.quartz.QuartzSchedulerFactory;
import org.opensingular.flow.schedule.quartz.QuartzTriggerFactory;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class QuartzScheduleService
implements IScheduleService,
Loggable {
    private static final String SCHEDULER_NAME = "SingularFlowScheduler";
    private static final String CONFIG_RESOURCE_NAME = "quartz";
    private static final String DEFAULT_CONFIG_RESOURCE_NAME = "quartz-default";
    private final QuartzSchedulerFactory quartzSchedulerFactory;

    public QuartzScheduleService() {
        this(false);
    }

    public QuartzScheduleService(QuartzSchedulerFactory quartzSchedulerFactory) {
        this.quartzSchedulerFactory = quartzSchedulerFactory;
        this.init();
    }

    public QuartzScheduleService(boolean waitJobsOnShutdown) {
        this.quartzSchedulerFactory = new QuartzSchedulerFactory();
        this.quartzSchedulerFactory.setWaitForJobsToCompleteOnShutdown(waitJobsOnShutdown);
        this.init();
    }

    private void init() {
        this.quartzSchedulerFactory.setSchedulerName(SCHEDULER_NAME);
        ResourceBundle quartzBundle = null;
        try {
            quartzBundle = ResourceBundle.getBundle(CONFIG_RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (quartzBundle == null) {
            quartzBundle = ResourceBundle.getBundle(DEFAULT_CONFIG_RESOURCE_NAME);
        }
        this.quartzSchedulerFactory.setConfigLocation(quartzBundle);
        try {
            this.quartzSchedulerFactory.initialize();
            this.quartzSchedulerFactory.start();
        }
        catch (Exception e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    @Override
    public void schedule(IScheduledJob scheduledJob) {
        try {
            this.quartzSchedulerFactory.addTrigger(QuartzTriggerFactory.newTrigger().withIdentity(scheduledJob.getId()).forJob(scheduledJob::run).withScheduleData(scheduledJob.getScheduleData()).build());
        }
        catch (Exception e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    @Override
    public void trigger(IScheduledJob scheduledJob) {
        try {
            this.quartzSchedulerFactory.triggerJob(new JobKey(scheduledJob.getId()));
        }
        catch (SchedulerException e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.quartzSchedulerFactory.destroy();
        }
        catch (SchedulerException e) {
            this.getLogger().trace(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set<JobKey> getAllJobKeys() throws SchedulerException {
        return this.quartzSchedulerFactory.getAllJobKeys();
    }
}

