/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.flow.schedule.quartz;

import java.io.IOException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.opensingular.flow.schedule.quartz.QuartzJobFactory;
import org.opensingular.flow.schedule.quartz.SchedulerAccessor;
import org.opensingular.lib.commons.base.SingularException;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobFactory;

public class QuartzSchedulerFactory
extends SchedulerAccessor {
    public static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    public static final int DEFAULT_THREAD_COUNT = 10;
    private Class<? extends SchedulerFactory> schedulerFactoryClass = StdSchedulerFactory.class;
    private String schedulerName;
    private ResourceBundle configLocation;
    private Properties quartzProperties;
    private JobFactory jobFactory;
    private boolean jobFactorySet = false;
    private boolean exposeSchedulerInRepository = false;
    private boolean waitForJobsToCompleteOnShutdown = false;
    private Scheduler scheduler;

    public void setSchedulerFactoryClass(Class<? extends SchedulerFactory> schedulerFactoryClass) {
        this.schedulerFactoryClass = schedulerFactoryClass;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setConfigLocation(ResourceBundle configLocation) {
        this.configLocation = configLocation;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setJobFactory(JobFactory jobFactory) {
        this.jobFactory = jobFactory;
        this.jobFactorySet = true;
    }

    public void setExposeSchedulerInRepository(boolean exposeSchedulerInRepository) {
        this.exposeSchedulerInRepository = exposeSchedulerInRepository;
    }

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void initialize() throws SingularException {
        try {
            SchedulerFactory schedulerFactory = this.schedulerFactoryClass.newInstance();
            this.initSchedulerFactory(schedulerFactory);
            this.scheduler = this.createScheduler(schedulerFactory, this.schedulerName);
            if (!this.jobFactorySet && !(this.scheduler instanceof RemoteScheduler)) {
                this.jobFactory = new QuartzJobFactory();
            }
            if (this.jobFactory != null) {
                this.scheduler.setJobFactory(this.jobFactory);
            }
            this.registerListeners();
            this.registerJobsAndTriggers();
        }
        catch (Exception e) {
            throw SingularException.rethrow((String)e.getMessage(), (Throwable)e);
        }
    }

    private void initSchedulerFactory(SchedulerFactory schedulerFactory) throws SchedulerException, IOException {
        Properties mergedProps = new Properties();
        mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        mergedProps.setProperty(PROP_THREAD_COUNT, Integer.toString(10));
        if (this.configLocation != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loading Quartz config from [" + this.configLocation + "]"));
            }
            this.fillProperties(mergedProps, this.configLocation);
        }
        this.mergePropertiesIntoMap(this.quartzProperties, mergedProps);
        if (this.schedulerName != null) {
            mergedProps.put("org.quartz.scheduler.instanceName", this.schedulerName);
        }
        ((StdSchedulerFactory)schedulerFactory).initialize(mergedProps);
    }

    private void fillProperties(Properties mergedProps, ResourceBundle configLocation) {
        if (mergedProps == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (configLocation != null) {
            Enumeration<String> en = configLocation.getKeys();
            while (en.hasMoreElements()) {
                String value;
                String key = en.nextElement();
                try {
                    value = configLocation.getString(key);
                }
                catch (MissingResourceException e) {
                    this.logger.info((Object)e.getMessage(), (Throwable)e);
                    value = null;
                }
                assert (value != null);
                mergedProps.put(key, value);
            }
        }
    }

    private void mergePropertiesIntoMap(Properties quartzProperties, Properties mergedProps) {
        if (mergedProps == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (quartzProperties != null) {
            Enumeration<?> en = quartzProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = quartzProperties.getProperty(key);
                if (value == null) {
                    value = quartzProperties.get(key);
                }
                assert (value != null);
                mergedProps.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        SchedulerRepository repository;
        SchedulerRepository schedulerRepository = repository = SchedulerRepository.getInstance();
        synchronized (schedulerRepository) {
            Scheduler existingScheduler = schedulerName != null ? repository.lookup(schedulerName) : null;
            Scheduler newScheduler = schedulerFactory.getScheduler();
            if (newScheduler == existingScheduler) {
                throw new IllegalStateException("Active Scheduler of name '" + schedulerName + "' already registered " + "in Quartz SchedulerRepository. Cannot create a new Spring-managed Scheduler of the same name!");
            }
            if (!this.exposeSchedulerInRepository) {
                SchedulerRepository.getInstance().remove(newScheduler.getSchedulerName());
            }
            return newScheduler;
        }
    }

    protected void startScheduler(final Scheduler scheduler, final int startupDelay) throws SchedulerException {
        if (startupDelay <= 0) {
            this.logger.info((Object)"Starting Quartz Scheduler now");
            scheduler.start();
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Will start Quartz Scheduler [" + scheduler.getSchedulerName() + "] in " + startupDelay + " seconds"));
            }
            Thread schedulerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep((long)startupDelay * 1000L);
                    }
                    catch (InterruptedException e) {
                        QuartzSchedulerFactory.this.logger.info((Object)e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    if (QuartzSchedulerFactory.this.logger.isInfoEnabled()) {
                        QuartzSchedulerFactory.this.logger.info((Object)("Starting Quartz Scheduler now, after delay of " + startupDelay + " seconds"));
                    }
                    try {
                        scheduler.start();
                    }
                    catch (SchedulerException e) {
                        QuartzSchedulerFactory.this.logger.error((Object)e.getMessage(), (Throwable)e);
                        throw SingularException.rethrow((String)e.getMessage(), (Throwable)e);
                    }
                }
            };
            schedulerThread.setName("Quartz Scheduler [" + scheduler.getSchedulerName() + "]");
            schedulerThread.setDaemon(true);
            schedulerThread.start();
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void start() throws SchedulerException {
        this.start(0);
    }

    public void start(int startupDelay) throws SchedulerException {
        if (this.scheduler != null) {
            this.startScheduler(this.scheduler, startupDelay);
        }
    }

    public void stop() throws SchedulerException {
        if (this.scheduler != null) {
            this.scheduler.standby();
        }
    }

    public void stop(Runnable callback) throws SchedulerException {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        if (this.scheduler != null) {
            try {
                return !this.scheduler.isInStandbyMode();
            }
            catch (SchedulerException e) {
                this.logger.info((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public void destroy() throws SchedulerException {
        this.logger.info((Object)"Shutting down Quartz Scheduler");
        this.scheduler.shutdown(this.waitForJobsToCompleteOnShutdown);
    }

    public void addJob(JobDetail jobDetail) throws SchedulerException {
        this.addJobToScheduler(jobDetail);
    }

    public void addTrigger(Trigger trigger, JobDetail jobDetail) throws SchedulerException {
        trigger.getJobDataMap().put("jobDetail", (Object)jobDetail);
        this.addTriggerToScheduler(trigger);
    }

    public void addTrigger(Trigger trigger) throws SchedulerException {
        this.addJobToScheduler((JobDetail)trigger.getJobDataMap().get((Object)"jobDetail"));
        this.addTriggerToScheduler(trigger);
    }

    public void triggerJob(JobKey jobKey) throws SchedulerException {
        this.getScheduler().triggerJob(jobKey);
    }
}

