/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.flow.schedule.quartz;

import java.util.function.Supplier;
import org.opensingular.flow.schedule.IScheduleData;
import org.opensingular.flow.schedule.ScheduledJob;
import org.opensingular.flow.schedule.quartz.QuartzJobFactory;
import org.opensingular.flow.schedule.quartz.QuartzScheduledJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class QuartzTriggerFactory {
    private Supplier<Object> job;
    private IScheduleData scheduleData = null;
    private JobBuilder jobBuilder = JobBuilder.newJob().ofType(QuartzScheduledJob.class).storeDurably();
    private boolean startNow = false;

    private QuartzTriggerFactory() {
    }

    public static QuartzTriggerFactory newTrigger() {
        return new QuartzTriggerFactory();
    }

    public QuartzTriggerFactory withScheduleData(IScheduleData scheduleData) {
        this.scheduleData = scheduleData;
        return this;
    }

    public QuartzTriggerFactory startNow() {
        this.startNow = true;
        return this;
    }

    public QuartzTriggerFactory withIdentity(String name, String group) {
        this.jobBuilder.withIdentity(name, group);
        return this;
    }

    public QuartzTriggerFactory withIdentity(String name) {
        this.jobBuilder.withIdentity(name);
        return this;
    }

    public QuartzTriggerFactory forJob(Supplier<Object> job) {
        this.job = job;
        return this;
    }

    public Trigger build() throws SchedulerException {
        JobDetail jobDetail = this.configureJob(this.jobBuilder.build(), this.scheduleData);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().forJob(jobDetail);
        if (this.scheduleData != null && !this.scheduleData.getCronExpression().isEmpty()) {
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.scheduleData.getCronExpression()));
        }
        if (this.startNow) {
            triggerBuilder.startNow();
        }
        Trigger trigger = triggerBuilder.build();
        trigger.getJobDataMap().put("jobDetail", (Object)jobDetail);
        return trigger;
    }

    private JobDetail configureJob(JobDetail jobDetail, IScheduleData scheduleData) {
        jobDetail.getJobDataMap().put(QuartzJobFactory.JOB_KEY, (Object)new ScheduledJob(jobDetail.getKey().getName(), scheduleData, this.job));
        return jobDetail;
    }
}

