/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.flow.schedule.quartz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.SimpleClassLoadHelper;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.xml.XMLSchedulingDataProcessor;

public abstract class SchedulerAccessor {
    protected static final String JOB_DETAIL_KEY = "jobDetail";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean overwriteExistingJobs = false;
    private String[] jobSchedulingDataLocations;
    private List<JobDetail> jobDetails;
    private Map<String, Calendar> calendars;
    private List<Trigger> triggers;
    private SchedulerListener[] schedulerListeners;
    private JobListener[] globalJobListeners;
    private TriggerListener[] globalTriggerListeners;

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setJobSchedulingDataLocation(String jobSchedulingDataLocation) {
        this.jobSchedulingDataLocations = new String[]{jobSchedulingDataLocation};
    }

    public void setJobSchedulingDataLocations(String ... jobSchedulingDataLocations) {
        this.jobSchedulingDataLocations = jobSchedulingDataLocations;
    }

    public void setJobDetails(JobDetail ... jobDetails) {
        this.jobDetails = new ArrayList<JobDetail>(Arrays.asList(jobDetails));
    }

    public void setCalendars(Map<String, Calendar> calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger ... triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    public void setSchedulerListeners(SchedulerListener ... schedulerListeners) {
        this.schedulerListeners = schedulerListeners;
    }

    public void setGlobalJobListeners(JobListener ... globalJobListeners) {
        this.globalJobListeners = globalJobListeners;
    }

    public void setGlobalTriggerListeners(TriggerListener ... globalTriggerListeners) {
        this.globalTriggerListeners = globalTriggerListeners;
    }

    protected void registerJobsAndTriggers() throws SchedulerException {
        try {
            if (this.jobSchedulingDataLocations != null) {
                SimpleClassLoadHelper clh = new SimpleClassLoadHelper();
                clh.initialize();
                XMLSchedulingDataProcessor xMLSchedulingDataProcessor = new XMLSchedulingDataProcessor((ClassLoadHelper)clh);
                for (String location : this.jobSchedulingDataLocations) {
                    xMLSchedulingDataProcessor.processFileAndScheduleJobs(location, this.getScheduler());
                }
            }
            if (this.jobDetails != null) {
                for (JobDetail jobDetail : this.jobDetails) {
                    this.addJobToScheduler(jobDetail);
                }
            } else {
                this.jobDetails = new LinkedList<JobDetail>();
            }
            if (this.calendars != null) {
                for (Map.Entry entry : this.calendars.entrySet()) {
                    this.getScheduler().addCalendar((String)entry.getKey(), (Calendar)entry.getValue(), true, true);
                }
            }
            if (this.triggers != null) {
                for (Trigger trigger : this.triggers) {
                    this.addTriggerToScheduler(trigger);
                }
            }
        }
        catch (SchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Registration of jobs and triggers failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean addJobToScheduler(JobDetail jobDetail) throws SchedulerException {
        if (this.overwriteExistingJobs || !this.jobDetailExists(jobDetail)) {
            this.getScheduler().addJob(jobDetail, true);
            return true;
        }
        return false;
    }

    protected boolean addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists = this.triggerExists(trigger);
        if (!triggerExists || this.overwriteExistingJobs) {
            JobDetail jobDetail = this.findJobDetail(trigger);
            if (jobDetail != null && !this.jobDetails.contains(jobDetail) && this.addJobToScheduler(jobDetail)) {
                this.jobDetails.add(jobDetail);
            }
            if (!triggerExists) {
                try {
                    this.getScheduler().scheduleJob(trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Unexpectedly found existing trigger, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored"));
                    }
                    if (this.overwriteExistingJobs) {
                        this.rescheduleJob(trigger);
                    }
                }
            } else {
                this.rescheduleJob(trigger);
            }
            return true;
        }
        return false;
    }

    private JobDetail findJobDetail(Trigger trigger) {
        return (JobDetail)trigger.getJobDataMap().remove((Object)JOB_DETAIL_KEY);
    }

    private boolean jobDetailExists(JobDetail jobDetail) throws SchedulerException {
        return this.getScheduler().getJobDetail(jobDetail.getKey()) != null;
    }

    private boolean triggerExists(Trigger trigger) throws SchedulerException {
        return this.getScheduler().getTrigger(trigger.getKey()) != null;
    }

    private void rescheduleJob(Trigger trigger) throws SchedulerException {
        this.getScheduler().rescheduleJob(trigger.getKey(), trigger);
    }

    protected void registerListeners() throws SchedulerException {
        ListenerManager listenerManager = this.getScheduler().getListenerManager();
        if (this.schedulerListeners != null) {
            for (SchedulerListener schedulerListener : this.schedulerListeners) {
                listenerManager.addSchedulerListener(schedulerListener);
            }
        }
        if (this.globalJobListeners != null) {
            for (SchedulerListener schedulerListener : this.globalJobListeners) {
                listenerManager.addJobListener((JobListener)schedulerListener, new LinkedList());
            }
        }
        if (this.globalTriggerListeners != null) {
            for (SchedulerListener schedulerListener : this.globalTriggerListeners) {
                listenerManager.addTriggerListener((TriggerListener)schedulerListener, new LinkedList());
            }
        }
    }

    public Set<JobKey> getAllJobKeys() throws SchedulerException {
        return this.getScheduler().getJobKeys(GroupMatcher.anyGroup());
    }

    protected abstract Scheduler getScheduler();
}

