/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.requirement.sei30.features;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.view.richtext.RichTextAction;
import org.opensingular.form.view.richtext.RichTextInsertContext;
import org.opensingular.lib.commons.lambda.IFunction;
import org.opensingular.lib.commons.ui.Icon;
import org.opensingular.requirement.sei30.features.SILinkSEI;
import org.opensingular.requirement.sei30.features.STypeLinkSEI;

public class InsertLinkSEIButtonRichText
implements RichTextAction<RichTextInsertContext> {
    private IFunction<SILinkSEI, String> functionActionLink;

    public InsertLinkSEIButtonRichText(@Nonnull IFunction<SILinkSEI, String> functionActionLink) {
        this.functionActionLink = functionActionLink;
    }

    public String getLabel() {
        return "Inserir um Link para processo ou documento do SEI!";
    }

    public Icon getIcon() {
        return (Icon & Serializable)() -> "sei-icon";
    }

    public Optional<Class<? extends SType<?>>> getForm() {
        return Optional.of(STypeLinkSEI.class);
    }

    public boolean getLabelInline() {
        return false;
    }

    public Class<? extends RichTextInsertContext> getType() {
        return RichTextInsertContext.class;
    }

    public void onAction(RichTextInsertContext richTextActionContext, Optional<SInstance> optional) {
        optional.ifPresent(instance -> {
            SILinkSEI instanceLinkSei = (SILinkSEI)((Object)instance);
            String protocolo = instanceLinkSei.getProtocolo();
            String idProtocolo = (String)this.functionActionLink.apply((Object)instanceLinkSei);
            if (protocolo != null && idProtocolo != null) {
                String retornoFormatado = "<span contenteditable=\"false\" style=\"text-indent:0px;\"><a id=lnkSei" + idProtocolo + " class=\"ancoraSei\" style=\"text-indent:0px;\">" + protocolo + "</a></span>";
                richTextActionContext.setReturnValue(retornoFormatado);
            }
        });
    }
}

