/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.requirement.connector.sei31;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.ws.BindingProvider;
import org.apache.commons.collections.CollectionUtils;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.commons.util.SingularIntegrationException;
import org.opensingular.lib.commons.util.TempFileUtils;
import org.opensingular.lib.commons.util.WSClientSafeWrapper;
import org.opensingular.requirement.connector.sei31.ConstantesSEI;
import org.opensingular.requirement.connector.sei31.SEIPortType;
import org.opensingular.requirement.connector.sei31.model.SimNao;
import org.opensingular.requirement.connector.sei31.model.TipoBlocoEnum;
import org.opensingular.requirement.connector.sei31.model.UnidadeSei;
import org.opensingular.requirement.connector.sei31.ws.ArquivoExtensao;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfArquivoExtensao;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfCargo;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfDocumento;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfDocumentoFormatado;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfHipoteseLegal;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfIdContatos;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfIdUnidade;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfProcedimentoRelacionado;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfSerie;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfTipoConferencia;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfTipoProcedimento;
import org.opensingular.requirement.connector.sei31.ws.ArrayOfUsuario;
import org.opensingular.requirement.connector.sei31.ws.Cargo;
import org.opensingular.requirement.connector.sei31.ws.Contato;
import org.opensingular.requirement.connector.sei31.ws.Documento;
import org.opensingular.requirement.connector.sei31.ws.Procedimento;
import org.opensingular.requirement.connector.sei31.ws.RetornoConsultaBloco;
import org.opensingular.requirement.connector.sei31.ws.RetornoConsultaDocumento;
import org.opensingular.requirement.connector.sei31.ws.RetornoConsultaProcedimento;
import org.opensingular.requirement.connector.sei31.ws.RetornoGeracaoProcedimento;
import org.opensingular.requirement.connector.sei31.ws.RetornoInclusaoDocumento;
import org.opensingular.requirement.connector.sei31.ws.SeiPortType;
import org.opensingular.requirement.connector.sei31.ws.SeiService;
import org.opensingular.requirement.connector.sei31.ws.Serie;
import org.opensingular.requirement.connector.sei31.ws.TipoConferencia;
import org.opensingular.requirement.connector.sei31.ws.TipoProcedimento;
import org.opensingular.requirement.connector.sei31.ws.Unidade;
import org.opensingular.requirement.connector.sei31.ws.Usuario;

public class SEIWS
implements SEIPortType,
Loggable {
    private static final int DEFAULT_TAMANHO_MULTIPART = 0xA00000;
    private final SeiPortType seiPortType;
    private final String siglaSistema;
    private final String identificacaoServico;
    private final Integer tamanhoMultiPart;

    public SEIWS(String siglaSistema, String identificacaoServico, String wsAddress) {
        this(siglaSistema, identificacaoServico, wsAddress, 0xA00000);
    }

    public SEIWS(String siglaSistema, String identificacaoServico, String wsAddress, Integer tamanhoMultiPart) {
        this.seiPortType = this.getSeiService(wsAddress);
        this.siglaSistema = siglaSistema;
        this.identificacaoServico = identificacaoServico;
        this.tamanhoMultiPart = tamanhoMultiPart != null ? tamanhoMultiPart : 0xA00000;
    }

    private SeiPortType getSeiService(String wsAddress) {
        SeiPortType seiServicePortType = new SeiService().getSeiPortService();
        BindingProvider bp = (BindingProvider)seiServicePortType;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", WSClientSafeWrapper.getAdressWithoutWsdl((String)wsAddress));
        return seiServicePortType;
    }

    @Override
    public RetornoGeracaoProcedimento gerarProcedimento(UnidadeSei unidade, Procedimento procedimento) {
        return this.gerarProcedimento(unidade, procedimento, ConstantesSEI.DOCUMENTOS_EMPTY, ConstantesSEI.PROCEDIMENTO_RELACIONADOS_EMPTY, ConstantesSEI.ID_UNIDADE_EMPTY, SimNao.NAO, SimNao.NAO, "", "", "");
    }

    @Override
    public RetornoGeracaoProcedimento gerarProcedimento(UnidadeSei unidade, Procedimento procedimento, ArrayOfDocumento documentos, ArrayOfProcedimentoRelacionado procedimentosRelacionados, ArrayOfIdUnidade unidadesEnvio, SimNao sinManterAbertoUnidade, SimNao sinEnviarEmailNotificacao, String dataRetornoProgramado, String idMarcador, String textoMarcador) {
        return this.seiPortType.gerarProcedimento(this.siglaSistema, this.identificacaoServico, unidade.getId(), procedimento, documentos, procedimentosRelacionados, unidadesEnvio, sinManterAbertoUnidade.getCodigo(), sinEnviarEmailNotificacao.getCodigo(), dataRetornoProgramado, "0", SimNao.NAO.getCodigo(), idMarcador, textoMarcador);
    }

    @Override
    public Boolean reabrirProcesso(UnidadeSei unidade, String protocoloProcedimento) {
        String retorno = this.seiPortType.reabrirProcesso(this.siglaSistema, this.identificacaoServico, unidade.getId(), protocoloProcedimento);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public List<Usuario> listarUsuarios(UnidadeSei unidade, String idUsuario) {
        ArrayOfUsuario arrayOfUsuario = this.seiPortType.listarUsuarios(this.siglaSistema, this.identificacaoServico, unidade.getId(), idUsuario);
        if (arrayOfUsuario == null) {
            return Collections.emptyList();
        }
        return arrayOfUsuario.getItem();
    }

    @Override
    public RetornoConsultaProcedimento consultarProcedimentoBasico(UnidadeSei unidade, String protocoloProcedimento) {
        return this.consultarProcedimento(unidade, protocoloProcedimento, SimNao.NAO, SimNao.NAO, SimNao.NAO, SimNao.NAO, SimNao.NAO, SimNao.NAO, SimNao.NAO, SimNao.NAO, SimNao.NAO);
    }

    @Override
    public RetornoConsultaProcedimento consultarProcedimento(UnidadeSei unidade, String protocoloProcedimento, SimNao sinRetornarAssuntos, SimNao sinRetornarInteressados, SimNao sinRetornarObservacoes, SimNao sinRetornarAndamentoGeracao, SimNao sinRetornarAndamentoConclusao, SimNao sinRetornarUltimoAndamento, SimNao sinRetornarUnidadesProcedimentoAberto, SimNao sinRetornarProcedimentosRelacionados, SimNao sinRetornarProcedimentosAnexados) {
        return this.seiPortType.consultarProcedimento(this.siglaSistema, this.identificacaoServico, unidade.getId(), protocoloProcedimento, sinRetornarAssuntos.getCodigo(), sinRetornarInteressados.getCodigo(), sinRetornarObservacoes.getCodigo(), sinRetornarAndamentoGeracao.getCodigo(), sinRetornarAndamentoConclusao.getCodigo(), sinRetornarUltimoAndamento.getCodigo(), sinRetornarUnidadesProcedimentoAberto.getCodigo(), sinRetornarProcedimentosRelacionados.getCodigo(), sinRetornarProcedimentosAnexados.getCodigo());
    }

    @Override
    public RetornoConsultaProcedimento consultarProcedimento(String protocoloProcedimento, SimNao sinRetornarAssuntos, SimNao sinRetornarInteressados, SimNao sinRetornarObservacoes, SimNao sinRetornarAndamentoGeracao, SimNao sinRetornarAndamentoConclusao, SimNao sinRetornarUltimoAndamento, SimNao sinRetornarUnidadesProcedimentoAberto, SimNao sinRetornarProcedimentosRelacionados, SimNao sinRetornarProcedimentosAnexados) {
        return this.seiPortType.consultarProcedimento(this.siglaSistema, this.identificacaoServico, "", protocoloProcedimento, sinRetornarAssuntos.getCodigo(), sinRetornarInteressados.getCodigo(), sinRetornarObservacoes.getCodigo(), sinRetornarAndamentoGeracao.getCodigo(), sinRetornarAndamentoConclusao.getCodigo(), sinRetornarUltimoAndamento.getCodigo(), sinRetornarUnidadesProcedimentoAberto.getCodigo(), sinRetornarProcedimentosRelacionados.getCodigo(), sinRetornarProcedimentosAnexados.getCodigo());
    }

    @Override
    public Boolean atribuirProcesso(UnidadeSei unidade, String protocoloProcedimento, String idUsuario, SimNao sinReabrir) {
        String retorno = this.seiPortType.atribuirProcesso(this.siglaSistema, this.identificacaoServico, unidade.getId(), protocoloProcedimento, idUsuario, sinReabrir.getCodigo());
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public Boolean incluirDocumentoBloco(UnidadeSei unidade, String idBloco, String protocoloDocumento) {
        String retorno = this.seiPortType.incluirDocumentoBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco, protocoloDocumento, null);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public Boolean concluirProcesso(UnidadeSei unidade, String protocoloProcedimento) {
        String retorno = this.seiPortType.concluirProcesso(this.siglaSistema, this.identificacaoServico, unidade.getId(), protocoloProcedimento);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public Boolean cancelarDisponibilizacaoBloco(UnidadeSei unidade, String idBloco) {
        String retorno = this.seiPortType.cancelarDisponibilizacaoBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public List<Unidade> listarUnidades(String idTipoProcedimento, String idSerie) {
        return this.seiPortType.listarUnidades(this.siglaSistema, this.identificacaoServico, idTipoProcedimento, idSerie).getItem();
    }

    @Override
    public List<Unidade> listarUnidades() {
        return this.seiPortType.listarUnidades(this.siglaSistema, this.identificacaoServico, "", "").getItem();
    }

    @Override
    public List<Serie> listarSeries(UnidadeSei unidade, String idTipoProcedimento) {
        ArrayOfSerie arrayOfSerie = this.seiPortType.listarSeries(this.siglaSistema, this.identificacaoServico, unidade.getId(), idTipoProcedimento);
        if (arrayOfSerie == null) {
            return Collections.emptyList();
        }
        return arrayOfSerie.getItem();
    }

    @Override
    public List<Serie> listarSeries() {
        ArrayOfSerie arrayOfSerie = this.seiPortType.listarSeries(this.siglaSistema, this.identificacaoServico, "", "");
        if (arrayOfSerie == null) {
            return Collections.emptyList();
        }
        return arrayOfSerie.getItem();
    }

    @Override
    public Boolean excluirBloco(UnidadeSei unidade, String idBloco) {
        String retorno = this.seiPortType.excluirBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public Boolean disponibilizarBloco(UnidadeSei unidade, String idBloco) {
        String retorno = this.seiPortType.disponibilizarBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public Boolean incluirProcessoBloco(UnidadeSei unidade, String idBloco, String protocoloProcedimento) {
        String retorno = this.seiPortType.incluirProcessoBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco, protocoloProcedimento, null);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public RetornoInclusaoDocumento incluirDocumento(UnidadeSei unidade, Documento documento) {
        return this.seiPortType.incluirDocumento(this.siglaSistema, this.identificacaoServico, unidade.getId(), documento);
    }

    @Override
    public String adicionarArquivo(UnidadeSei unidade, String nome, String tamanho, String hash, String conteudo) {
        return this.seiPortType.adicionarArquivo(this.siglaSistema, this.identificacaoServico, unidade.getId(), nome, tamanho, hash, conteudo);
    }

    @Override
    public String adicionarConteudoArquivo(UnidadeSei unidade, String idArquivo, String conteudo) {
        return this.seiPortType.adicionarConteudoArquivo(this.siglaSistema, this.identificacaoServico, unidade.getId(), idArquivo, conteudo);
    }

    @Override
    public String adicionarArquivoMultipart(UnidadeSei unidade, String nome, String tamanho, String hash, File base64Conteudo) {
        int offset = 0;
        int tam = 0;
        String idArquivo = null;
        String conteudoParcial = null;
        try {
            while ((long)offset < base64Conteudo.length()) {
                tam = (int)Math.min((long)this.tamanhoMultiPart.intValue(), base64Conteudo.length() - (long)offset);
                conteudoParcial = TempFileUtils.readPartOfFileToString((File)base64Conteudo, (int)offset, (int)tam);
                if (offset == 0) {
                    idArquivo = this.adicionarArquivo(unidade, nome, tamanho, hash, conteudoParcial);
                } else {
                    this.adicionarConteudoArquivo(unidade, idArquivo, conteudoParcial);
                }
                offset += tam;
            }
        }
        catch (IOException e) {
            SingularIntegrationException.rethrow((String)"N\u00e3o foi poss\u00edvel ler o arquivo a ser adicionado no SEI.", (Throwable)e);
        }
        return idArquivo;
    }

    @Override
    public String gerarBloco(UnidadeSei unidade, TipoBlocoEnum tipoBlocoEnum, String descricao, ArrayOfIdUnidade unidadesDisponibilizacao, ArrayOfDocumentoFormatado documentos, SimNao sinDisponibilizar) {
        return this.seiPortType.gerarBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), tipoBlocoEnum.getSigla(), descricao, unidadesDisponibilizacao, documentos, sinDisponibilizar.getCodigo());
    }

    @Override
    public String gerarBloco(UnidadeSei unidade, TipoBlocoEnum tipoBlocoEnum, String descricao) {
        return this.gerarBloco(unidade, tipoBlocoEnum, descricao, ConstantesSEI.ID_UNIDADE_EMPTY, ConstantesSEI.DOCUMENTOS_FORMATADOS_EMPTY, SimNao.NAO);
    }

    @Override
    public RetornoConsultaDocumento consultarDocumento(UnidadeSei unidade, String protocoloDocumento, SimNao sinRetornarAndamentoGeracao, SimNao sinRetornarAssinaturas, SimNao sinRetornarPublicacao, SimNao sinRetornarCampos) {
        return this.seiPortType.consultarDocumento(this.siglaSistema, this.identificacaoServico, unidade != null ? unidade.getId() : "", protocoloDocumento, sinRetornarAndamentoGeracao.getCodigo(), sinRetornarAssinaturas.getCodigo(), sinRetornarPublicacao.getCodigo(), sinRetornarCampos.getCodigo());
    }

    @Override
    public RetornoConsultaDocumento consultarDocumento(UnidadeSei unidade, String protocoloDocumento) {
        return this.consultarDocumento(unidade, protocoloDocumento, SimNao.NAO, SimNao.NAO, SimNao.NAO, SimNao.NAO);
    }

    @Override
    public RetornoConsultaDocumento consultarDocumentoPublicacao(UnidadeSei unidade, String protocoloDocumento) {
        return this.consultarDocumento(unidade, protocoloDocumento, SimNao.NAO, SimNao.NAO, SimNao.SIM, SimNao.NAO);
    }

    @Override
    public RetornoConsultaDocumento consultarDocumentoAssinatura(UnidadeSei unidade, String protocoloDocumento) {
        return this.consultarDocumento(unidade, protocoloDocumento, SimNao.NAO, SimNao.SIM, SimNao.NAO, SimNao.NAO);
    }

    @Override
    public Boolean enviarProcesso(UnidadeSei unidade, String protocoloProcedimento, ArrayOfIdUnidade unidadesDestino, SimNao sinManterAbertoUnidade, SimNao sinRemoverAnotacao, SimNao sinEnviarEmailNotificacao, String dataRetornoProgramado, String diasRetornoProgramado) {
        String retorno = this.seiPortType.enviarProcesso(this.siglaSistema, this.identificacaoServico, unidade.getId(), protocoloProcedimento, unidadesDestino, sinManterAbertoUnidade.getCodigo(), sinRemoverAnotacao.getCodigo(), sinEnviarEmailNotificacao.getCodigo(), dataRetornoProgramado, diasRetornoProgramado, SimNao.NAO.getCodigo(), SimNao.NAO.getCodigo());
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public Boolean retirarDocumentoBloco(UnidadeSei unidade, String idBloco, String protocoloDocumento) {
        String retorno = this.seiPortType.retirarDocumentoBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco, protocoloDocumento);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public Boolean retirarProcessoBloco(UnidadeSei unidade, String idBloco, String protocoloProcedimento) {
        String retorno = this.seiPortType.retirarProcessoBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco, protocoloProcedimento);
        return this.converterRetornoBooleano(retorno);
    }

    @Override
    public List<ArquivoExtensao> listarExtensoesPermitidas(UnidadeSei unidade, String idArquivoExtensao) {
        ArrayOfArquivoExtensao arrayOfArquivoExtensao = this.seiPortType.listarExtensoesPermitidas(this.siglaSistema, this.identificacaoServico, unidade.getId(), idArquivoExtensao);
        if (arrayOfArquivoExtensao == null) {
            return Collections.emptyList();
        }
        return arrayOfArquivoExtensao.getItem();
    }

    @Override
    public List<TipoProcedimento> listarTiposProcedimento(UnidadeSei unidade, String idSerie) {
        ArrayOfTipoProcedimento arrayOfTipoProcedimento = this.seiPortType.listarTiposProcedimento(this.siglaSistema, this.identificacaoServico, unidade.getId(), idSerie);
        if (arrayOfTipoProcedimento == null) {
            return Collections.emptyList();
        }
        return arrayOfTipoProcedimento.getItem();
    }

    @Override
    public List<TipoProcedimento> listarTiposProcedimento() {
        ArrayOfTipoProcedimento arrayOfTipoProcedimento = this.seiPortType.listarTiposProcedimento(this.siglaSistema, this.identificacaoServico, "", "");
        if (arrayOfTipoProcedimento == null) {
            return Collections.emptyList();
        }
        return arrayOfTipoProcedimento.getItem();
    }

    private Boolean converterRetornoBooleano(String valor) {
        if (valor == null) {
            return null;
        }
        return !"0".equalsIgnoreCase(valor.trim());
    }

    @Override
    public RetornoConsultaBloco consultarBloco(UnidadeSei unidade, String idBloco) {
        return this.seiPortType.consultarBloco(this.siglaSistema, this.identificacaoServico, unidade.getId(), idBloco, SimNao.SIM.getCodigo());
    }

    @Override
    public String cancelarDocumento(UnidadeSei unidade, String protocoloDocumento, String motivo) {
        return this.seiPortType.cancelarDocumento(this.siglaSistema, this.identificacaoServico, unidade.getId(), protocoloDocumento, motivo);
    }

    @Override
    public List<Contato> listarContatos(@Nullable UnidadeSei unidade, String idTipoContato, String sigla) {
        return this.seiPortType.listarContatos(this.siglaSistema, this.identificacaoServico, Optional.ofNullable(unidade).map(UnidadeSei::getId).orElse(""), idTipoContato, "", "", sigla, "", "", "", "", new ArrayOfIdContatos()).getItem();
    }

    @Override
    public Contato findContatoByCPF(@Nullable UnidadeSei unidade, String idTipoContato, String cpf) {
        List<Contato> contatoList = this.seiPortType.listarContatos(this.siglaSistema, this.identificacaoServico, Optional.ofNullable(unidade).map(UnidadeSei::getId).orElse(""), idTipoContato, "", "", "", "", cpf, "", "", new ArrayOfIdContatos()).getItem();
        if (CollectionUtils.isNotEmpty(contatoList)) {
            if (contatoList.size() > 1) {
                this.getLogger().warn("Was found more than one contact with the same CPF: {}", (Object)cpf);
            }
            return contatoList.get(0);
        }
        return null;
    }

    @Override
    public List<Contato> listarContatosPorCPF(String idTipoContato, String cpf) {
        return this.seiPortType.listarContatos(this.siglaSistema, this.identificacaoServico, "", idTipoContato, "", "", "", "", cpf, "", "", new ArrayOfIdContatos()).getItem();
    }

    @Override
    public ArrayOfHipoteseLegal listarHipotesesLegais(String idUnidade, String nivelAcesso) {
        return this.seiPortType.listarHipotesesLegais(this.siglaSistema, this.identificacaoServico, idUnidade, nivelAcesso);
    }

    @Override
    public List<Cargo> listarCargos() {
        ArrayOfCargo arrayOfCargo = this.seiPortType.listarCargos(this.siglaSistema, this.identificacaoServico, "", "");
        if (arrayOfCargo == null) {
            return Collections.emptyList();
        }
        return arrayOfCargo.getItem();
    }

    @Override
    public List<TipoConferencia> listarTiposConferencia() {
        return this.listarTiposConferencia(null);
    }

    @Override
    public List<TipoConferencia> listarTiposConferencia(@Nullable UnidadeSei unidadeSei) {
        String idUnidadeSei = Optional.ofNullable(unidadeSei).map(UnidadeSei::getId).orElse("");
        ArrayOfTipoConferencia arrayOfTipoConferencia = this.seiPortType.listarTiposConferencia(this.siglaSistema, this.identificacaoServico, idUnidadeSei);
        if (arrayOfTipoConferencia == null) {
            return Collections.emptyList();
        }
        return arrayOfTipoConferencia.getItem();
    }
}

