/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.schedule;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.opensingular.app.commons.mail.schedule.SingularLocalDataSourceJobStore;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.schedule.quartz.QuartzJobFactory;
import org.opensingular.schedule.quartz.SingularSchedulerAccessor;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.quartz.LocalTaskExecutorThreadPool;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SingularSchedulerBean
extends SingularSchedulerAccessor
implements FactoryBean<Scheduler>,
BeanNameAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
SmartLifecycle,
Loggable {
    public static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    public static final int DEFAULT_THREAD_COUNT = 10;
    private static final ThreadLocal<Executor> configTimeTaskExecutorHolder = new ThreadLocal();
    private static final ThreadLocal<DataSource> configTimeDataSourceHolder = new ThreadLocal();
    private static final ThreadLocal<DataSource> configTimeNonTransactionalDataSourceHolder = new ThreadLocal();
    private Class<? extends SchedulerFactory> schedulerFactoryClass = StdSchedulerFactory.class;
    private String schedulerName;
    private Resource configLocation;
    private Properties quartzProperties;
    private Executor taskExecutor;
    private DataSource dataSource;
    private DataSource nonTransactionalDataSource;
    private Map<String, ?> schedulerContextMap;
    private ApplicationContext applicationContext;
    private String applicationContextSchedulerContextKey;
    private JobFactory jobFactory;
    private boolean jobFactorySet = false;
    private int startupDelay = 0;
    private int phase = Integer.MAX_VALUE;
    private boolean exposeSchedulerInRepository = false;
    private boolean waitForJobsToCompleteOnShutdown = false;
    private Scheduler scheduler;

    public SingularSchedulerBean(DataSource dataSource) {
        Properties properties = new Properties();
        properties.setProperty("org.quartz.scheduler.instanceName", "SingularFlowScheduler");
        properties.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        if (SingularProperties.get().isTrue("singular.quartz.jobstore.enabled")) {
            properties.setProperty("org.quartz.jobStore.useProperties", "false");
            properties.setProperty("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
            properties.setProperty("org.quartz.jobStore.driverDelegateClass", SingularProperties.getOpt((String)"singular.quartz.driverDelegateClass").orElse("org.quartz.impl.jdbcjobstore.StdJDBCDelegate"));
            properties.setProperty("org.quartz.jobStore.tablePrefix", SingularProperties.getOpt((String)"singular.quartz.tablePrefix").orElse("QRTZ_"));
            properties.setProperty("org.quartz.jobStore.isClustered", "true");
            this.setDataSource(dataSource);
            this.setOverwriteExistingJobs(true);
        } else {
            properties.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        }
        this.setQuartzProperties(properties);
    }

    public static Executor getConfigTimeTaskExecutor() {
        return configTimeTaskExecutorHolder.get();
    }

    public static DataSource getConfigTimeDataSource() {
        return configTimeDataSourceHolder.get();
    }

    public static DataSource getConfigTimeNonTransactionalDataSource() {
        return configTimeNonTransactionalDataSourceHolder.get();
    }

    public void setSchedulerFactoryClass(Class<? extends SchedulerFactory> schedulerFactoryClass) {
        Assert.isAssignable(SchedulerFactory.class, schedulerFactoryClass);
        this.schedulerFactoryClass = schedulerFactoryClass;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setConfigLocation(ResourceBundle configLocation) {
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNonTransactionalDataSource(DataSource nonTransactionalDataSource) {
        this.nonTransactionalDataSource = nonTransactionalDataSource;
    }

    public void setSchedulerContextAsMap(Map<String, ?> schedulerContextAsMap) {
        this.schedulerContextMap = schedulerContextAsMap;
    }

    public void setApplicationContextSchedulerContextKey(String applicationContextSchedulerContextKey) {
        this.applicationContextSchedulerContextKey = applicationContextSchedulerContextKey;
    }

    public void setJobFactory(JobFactory jobFactory) {
        this.jobFactory = jobFactory;
        this.jobFactorySet = true;
    }

    public void setAutoStartup(boolean autoStartup) {
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setStartupDelay(int startupDelay) {
        this.startupDelay = startupDelay;
    }

    public void setExposeSchedulerInRepository(boolean exposeSchedulerInRepository) {
        this.exposeSchedulerInRepository = exposeSchedulerInRepository;
    }

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void initialize() throws SingularException {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception e) {
            throw SingularException.rethrow((String)e.getMessage(), (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null && this.nonTransactionalDataSource != null) {
            this.dataSource = this.nonTransactionalDataSource;
        }
        SchedulerFactory schedulerFactory = (SchedulerFactory)BeanUtils.instantiateClass(this.schedulerFactoryClass);
        this.initSchedulerFactory(schedulerFactory);
        if (this.taskExecutor != null) {
            configTimeTaskExecutorHolder.set(this.taskExecutor);
        }
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.nonTransactionalDataSource != null) {
            configTimeNonTransactionalDataSourceHolder.set(this.nonTransactionalDataSource);
        }
        try {
            this.scheduler = this.createScheduler(schedulerFactory, this.schedulerName);
            this.populateSchedulerContext();
            if (!this.jobFactorySet && !(this.scheduler instanceof RemoteScheduler)) {
                this.jobFactory = new QuartzJobFactory();
            }
            if (this.jobFactory != null) {
                this.scheduler.setJobFactory(this.jobFactory);
            }
        }
        finally {
            if (this.taskExecutor != null) {
                configTimeTaskExecutorHolder.remove();
            }
            if (this.dataSource != null) {
                configTimeDataSourceHolder.remove();
            }
            if (this.nonTransactionalDataSource != null) {
                configTimeNonTransactionalDataSourceHolder.remove();
            }
        }
        this.registerListeners();
        this.registerJobsAndTriggers();
    }

    private void initSchedulerFactory(SchedulerFactory schedulerFactory) throws SchedulerException, IOException {
        if (!(schedulerFactory instanceof StdSchedulerFactory)) {
            if (this.configLocation != null || this.quartzProperties != null || this.taskExecutor != null || this.dataSource != null) {
                throw new IllegalArgumentException("StdSchedulerFactory required for applying Quartz properties: " + schedulerFactory);
            }
            return;
        }
        Properties mergedProps = new Properties();
        if (this.taskExecutor != null) {
            mergedProps.setProperty("org.quartz.threadPool.class", LocalTaskExecutorThreadPool.class.getName());
        } else {
            mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
            mergedProps.setProperty(PROP_THREAD_COUNT, Integer.toString(10));
        }
        if (this.configLocation != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loading Quartz config from [" + this.configLocation + "]"));
            }
            PropertiesLoaderUtils.fillProperties((Properties)mergedProps, (Resource)this.configLocation);
        }
        CollectionUtils.mergePropertiesIntoMap((Properties)this.quartzProperties, (Map)mergedProps);
        if (this.dataSource != null) {
            mergedProps.put("org.quartz.jobStore.class", SingularLocalDataSourceJobStore.class.getName());
        }
        if (this.schedulerName != null) {
            mergedProps.put("org.quartz.scheduler.instanceName", this.schedulerName);
        }
        ((StdSchedulerFactory)schedulerFactory).initialize(mergedProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        try {
            SchedulerRepository repository;
            SchedulerRepository schedulerRepository = repository = SchedulerRepository.getInstance();
            synchronized (schedulerRepository) {
                Scheduler existingScheduler = schedulerName != null ? repository.lookup(schedulerName) : null;
                Scheduler newScheduler = schedulerFactory.getScheduler();
                if (newScheduler == existingScheduler) {
                    throw new IllegalStateException("Active Scheduler of name '" + schedulerName + "' already registered in Quartz SchedulerRepository. Cannot create a new Spring-managed Scheduler of the same name!");
                }
                if (!this.exposeSchedulerInRepository) {
                    SchedulerRepository.getInstance().remove(newScheduler.getSchedulerName());
                }
                return newScheduler;
            }
        }
        catch (Exception e) {
            this.getLogger().debug(e.getMessage(), (Throwable)e);
            throw new SchedulerException((Throwable)e);
        }
    }

    private void populateSchedulerContext() throws SchedulerException {
        if (this.schedulerContextMap != null) {
            this.scheduler.getContext().putAll(this.schedulerContextMap);
        }
        if (this.applicationContextSchedulerContextKey != null) {
            if (this.applicationContext == null) {
                throw new IllegalStateException("SchedulerFactoryBean needs to be set up in an ApplicationContext to be able to handle an 'applicationContextSchedulerContextKey'");
            }
            this.scheduler.getContext().put(this.applicationContextSchedulerContextKey, (Object)this.applicationContext);
        }
    }

    protected void startScheduler(final Scheduler scheduler, final int startupDelay) throws SchedulerException {
        if (startupDelay <= 0) {
            this.logger.info((Object)"Starting Quartz Scheduler now");
            scheduler.start();
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Will start Quartz Scheduler [" + scheduler.getSchedulerName() + "] in " + startupDelay + " seconds"));
            }
            Thread schedulerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep((long)startupDelay * 1000L);
                    }
                    catch (InterruptedException ex) {
                        SingularSchedulerBean.this.getLogger().trace(ex.getMessage(), (Throwable)ex);
                    }
                    if (SingularSchedulerBean.this.logger.isInfoEnabled()) {
                        SingularSchedulerBean.this.logger.info((Object)("Starting Quartz Scheduler now, after delay of " + startupDelay + " seconds"));
                    }
                    try {
                        scheduler.start();
                    }
                    catch (SchedulerException ex) {
                        throw new SchedulingException("Could not start Quartz Scheduler after delay", (Throwable)ex);
                    }
                }
            };
            schedulerThread.setName("Quartz Scheduler [" + scheduler.getSchedulerName() + "]");
            schedulerThread.setDaemon(true);
            schedulerThread.start();
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void start() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                this.startScheduler(this.scheduler, this.startupDelay);
            }
            catch (SchedulerException ex) {
                throw new SchedulingException("Could not start Quartz Scheduler", (Throwable)ex);
            }
        }
    }

    public void start(int startupDelay) throws SchedulerException {
    }

    public void stop() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                this.scheduler.standby();
            }
            catch (SchedulerException ex) {
                throw new SchedulingException("Could not stop Quartz Scheduler", (Throwable)ex);
            }
        }
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) throws SchedulingException {
        this.stop();
        callback.run();
    }

    public boolean isRunning() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                return !this.scheduler.isInStandbyMode();
            }
            catch (SchedulerException ex) {
                this.getLogger().trace(ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    public void destroy() throws SchedulerException {
        this.logger.info((Object)"Shutting down Quartz Scheduler");
        this.scheduler.shutdown(this.waitForJobsToCompleteOnShutdown);
    }

    public void setBeanName(String name) {
        if (this.schedulerName == null) {
            this.schedulerName = name;
        }
    }

    public Scheduler getObject() throws Exception {
        return this.scheduler;
    }

    public Class<?> getObjectType() {
        return this.scheduler != null ? this.scheduler.getClass() : Scheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public int getPhase() {
        return this.phase;
    }

    public void addJob(JobDetail jobDetail) throws SchedulerException {
        this.addJobToScheduler(jobDetail);
    }

    public void addTrigger(Trigger trigger, JobDetail jobDetail) throws SchedulerException {
        trigger.getJobDataMap().put("jobDetail", (Object)jobDetail);
        this.addTriggerToScheduler(trigger);
    }

    public void addTrigger(Trigger trigger) throws SchedulerException {
        this.addJobToScheduler((JobDetail)trigger.getJobDataMap().get((Object)"jobDetail"));
        this.addTriggerToScheduler(trigger);
    }

    public void triggerJob(JobKey jobKey) throws SchedulerException {
        this.getScheduler().triggerJob(jobKey);
    }

    public Set<JobKey> getAllJobKeys() throws SchedulerException {
        return this.getScheduler().getJobKeys(GroupMatcher.anyGroup());
    }
}

