/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.service.dto;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.app.commons.mail.persistence.entity.email.EmailAddresseeEntity;
import org.opensingular.app.commons.mail.persistence.entity.enums.AddresseType;
import org.opensingular.form.SingularFormException;
import org.opensingular.form.io.HashUtil;
import org.opensingular.form.type.core.attachment.IAttachmentRef;
import org.opensingular.form.type.core.attachment.handlers.FileSystemAttachmentRef;

public class Email {
    private Set<String> replyTo = new HashSet<String>();
    private String subject;
    private String content;
    private SetMultimap<AddresseType, Addressee> recipients = HashMultimap.create();
    private List<IAttachmentRef> attachments = new ArrayList<IAttachmentRef>(0);
    private Date creationDate;
    private String aliasFrom;
    private String moduleCod;

    public Email withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Email withModuleCod(@Nullable String moduleCod) {
        this.moduleCod = moduleCod;
        return this;
    }

    public Email withContent(String content) {
        this.content = content;
        return this;
    }

    public Email addAttachment(File file, String name) {
        try {
            String sha1 = HashUtil.toSHA1Base16((File)file);
            return this.addAttachments(new IAttachmentRef[]{new FileSystemAttachmentRef(file.getName(), sha1, file.getAbsolutePath(), file.length(), name)});
        }
        catch (Exception e) {
            throw new SingularFormException("Erro lendo origem de dados", (Throwable)e);
        }
    }

    public Email addAttachments(IAttachmentRef ... attachmentRefs) {
        for (IAttachmentRef attachmentRef : attachmentRefs) {
            this.attachments.add(attachmentRef);
        }
        return this;
    }

    public Email addAttachments(Collection<IAttachmentRef> attachmentRefs) {
        for (IAttachmentRef attachmentRef : attachmentRefs) {
            this.attachments.add(attachmentRef);
        }
        return this;
    }

    public Email addTo(String ... addresses) {
        return this.addRecipients(AddresseType.TO, addresses);
    }

    public Email addTo(Collection<String> addresses) {
        return this.addRecipients(AddresseType.TO, addresses.stream());
    }

    public Email addCc(String ... addresses) {
        return this.addRecipients(AddresseType.CC, addresses);
    }

    public Email addCc(Collection<String> addresses) {
        return this.addRecipients(AddresseType.CC, addresses.stream());
    }

    public Email addBcc(String ... addresses) {
        return this.addRecipients(AddresseType.BCC, addresses);
    }

    public Email addBcc(Collection<String> addresses) {
        return this.addRecipients(AddresseType.BCC, addresses.stream());
    }

    private Email addRecipients(AddresseType addresseType, String ... addresses) {
        return this.addRecipients(addresseType, Arrays.stream(addresses));
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public String getModuleCod() {
        return this.moduleCod;
    }

    public List<Addressee> getAllRecipients() {
        return Lists.newArrayList((Iterable)this.recipients.values());
    }

    public List<IAttachmentRef> getAttachments() {
        return this.attachments;
    }

    public Set<String> getReplyTo() {
        return this.replyTo;
    }

    public Email addReplyTo(String ... addresses) {
        for (String address : addresses) {
            if (!StringUtils.isNotBlank((CharSequence)address)) continue;
            for (String address_ : address.split(";")) {
                this.replyTo.add(address_);
            }
        }
        return this;
    }

    public String getReplyToJoining() {
        return this.replyTo.stream().collect(Collectors.joining(";"));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    protected Email addRecipients(AddresseType addresseType, Stream<String> addresses) {
        addresses.filter(StringUtils::isNotBlank).forEach(address -> this.recipients.put((Object)addresseType, (Object)new Addressee(null, this, addresseType, (String)address, null)));
        return this;
    }

    public String getAliasFrom() {
        return this.aliasFrom;
    }

    public Email setAliasFrom(String aliasFrom) {
        this.aliasFrom = aliasFrom;
        return this;
    }

    public static class Addressee {
        private final Long cod;
        private final Email email;
        private final AddresseType type;
        private final String address;
        private Date sentDate;

        public Addressee(Email email, EmailAddresseeEntity addresseeEntity) {
            this.cod = addresseeEntity.getCod();
            this.email = email;
            this.type = addresseeEntity.getAddresseType();
            this.address = addresseeEntity.getAddress();
            this.sentDate = addresseeEntity.getSentDate();
            email.recipients.put((Object)this.type, (Object)this);
        }

        Addressee(Long cod, Email email, AddresseType addresseType, String address, Date sentDate) {
            this.cod = cod;
            this.email = email;
            this.type = addresseType;
            this.address = address;
            this.sentDate = sentDate;
        }

        public Long getCod() {
            return this.cod;
        }

        public Email getEmail() {
            return this.email;
        }

        public AddresseType getType() {
            return this.type;
        }

        public String getAddress() {
            return this.address;
        }

        public Date getSentDate() {
            return this.sentDate;
        }

        public void setSentDate(Date sentDate) {
            this.sentDate = sentDate;
        }
    }
}

