/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.service.email;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.BooleanUtils;
import org.opensingular.app.commons.mail.service.dto.Email;
import org.opensingular.app.commons.mail.service.email.MailDataSourceIAttachmentRefAdapter;
import org.opensingular.form.type.core.attachment.IAttachmentRef;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class EmailSender
extends JavaMailSenderImpl
implements Loggable {
    private static final String EMAIL_DEVELOPMENT = "opensingular@gmail.com";
    private String from;
    private Cache<Class, Boolean> errorCache;

    @PostConstruct
    public void init() {
        SingularProperties properties = SingularProperties.get();
        this.setHost(properties.getPropertyOpt("singular.mail.host").orElse(null));
        if (this.getHost() != null) {
            this.from = properties.getPropertyOpt("singular.mail.from").orElse(null);
            this.setPort(properties.getPropertyOpt("singular.mail.port").orElse(null));
            this.setUsername(properties.getPropertyOpt("singular.mail.username").orElse(null));
            this.setPassword(properties.getPropertyOpt("singular.mail.password").orElse(null));
            this.setProtocol(properties.getPropertyOpt("singular.mail.protocol").orElse(null));
            this.getJavaMailProperties().setProperty("mail.smtp.host", this.getHost());
            this.getJavaMailProperties().setProperty("mail.smtp.port", String.valueOf(this.getPort()));
            if (this.getUsername() != null) {
                this.getJavaMailProperties().setProperty("mail.smtp.user", this.getUsername());
            }
            properties.getPropertyOpt("singular.mail.auth").ifPresent(v -> this.getJavaMailProperties().put("mail.smtp.auth", v));
            properties.getPropertyOpt("singular.mail.smtp.starttls.enable").ifPresent(v -> this.getJavaMailProperties().put("mail.smtp.starttls.enable", v));
            properties.getPropertyOpt("singular.mail.smtp.ssl.trust").ifPresent(v -> this.getJavaMailProperties().put("mail.smtp.ssl.trust", v));
            this.getLogger().info("SMTP mail sender Enabled.");
        } else {
            this.getLogger().warn("SMTP mail sender Disabled.");
        }
        this.errorCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(100L).expireAfterWrite(1L, TimeUnit.DAYS).build();
    }

    public boolean send(Email.Addressee addressee) {
        if (this.getHost() == null) {
            this.getLogger().info("SMTP mail sender Disabled.");
            return false;
        }
        if (addressee.getSentDate() == null) {
            try {
                Email e = addressee.getEmail();
                MimeMessage msg = this.createMimeMessage();
                msg.setHeader("Precedence", "bulk");
                msg.setHeader("X-Auto-Response-Suppress", "OOF");
                msg.setSubject(e.getSubject());
                msg.setSentDate(Optional.ofNullable(e.getCreationDate()).orElseGet(Date::new));
                msg.setFrom((Address)new InternetAddress(Optional.ofNullable(this.from).orElseGet(() -> ((EmailSender)this).getUsername()), addressee.getEmail().getAliasFrom()));
                Message.RecipientType recipientType = addressee.getType().getRecipientType();
                if (SingularProperties.get().isTrue("singular.send.email")) {
                    msg.addRecipient(recipientType, (Address)new InternetAddress(addressee.getAddress()));
                } else {
                    msg.addRecipient(recipientType, (Address)new InternetAddress(SingularProperties.get().getProperty("singular.email.rcpt.test", EMAIL_DEVELOPMENT)));
                }
                MimeMultipart content = new MimeMultipart("related");
                MimeBodyPart mainContent = new MimeBodyPart();
                mainContent.setContent((Object)e.getContent(), "text/html; charset=iso-8859-1");
                content.addBodyPart((BodyPart)mainContent);
                for (IAttachmentRef attachmentRef : e.getAttachments()) {
                    MimeBodyPart part = new MimeBodyPart();
                    part.setDisposition("attachment");
                    part.setHeader("Content-ID", "<" + attachmentRef.getName() + ">");
                    part.setDataHandler(new DataHandler((DataSource)new MailDataSourceIAttachmentRefAdapter(attachmentRef)));
                    part.setFileName(attachmentRef.getName());
                    part.setDescription(attachmentRef.getName());
                    content.addBodyPart((BodyPart)part);
                }
                msg.setContent((Multipart)content);
                msg.saveChanges();
                this.send(msg);
                addressee.setSentDate(new Date());
                this.getLogger().info("Email enviado para o destinat\u00e1rio(cod={})={}", (Object)addressee.getCod(), (Object)addressee.getAddress());
            }
            catch (Exception ex) {
                addressee.setSentDate(null);
                String msg = "ERRO ao enviar email para o destinat\u00e1rio(cod=" + addressee.getCod() + ")=" + addressee.getAddress();
                if (BooleanUtils.isTrue((Boolean)((Boolean)this.errorCache.getIfPresent(ex.getClass())))) {
                    this.getLogger().error(msg);
                } else {
                    this.getLogger().error(msg, (Throwable)ex);
                    this.errorCache.put(ex.getClass(), (Object)Boolean.TRUE);
                }
                return false;
            }
        }
        return true;
    }

    public void setPort(String port) {
        if (port != null) {
            super.setPort(Integer.parseInt(port));
        }
    }
}

