/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.service.email;

import java.util.Optional;
import javax.inject.Inject;
import org.opensingular.app.commons.mail.service.dto.Email;
import org.opensingular.app.commons.mail.service.email.EmailPersistenceService;
import org.opensingular.app.commons.mail.service.email.EmailSender;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.schedule.IScheduleData;
import org.opensingular.schedule.IScheduledJob;

public class EmailSenderScheduledJob
implements IScheduledJob,
Loggable {
    @Inject
    private EmailSender emailSender;
    @Inject
    private EmailPersistenceService emailPersistenceService;
    private IScheduleData scheduleData;
    private int emailsPerPage = 20;
    private String identifierModule;

    public EmailSenderScheduledJob(IScheduleData scheduleData) {
        this.scheduleData = scheduleData;
    }

    public EmailSenderScheduledJob(IScheduleData scheduleData, String identifierModule) {
        this(scheduleData);
        this.identifierModule = identifierModule;
    }

    public IScheduleData getScheduleData() {
        return this.scheduleData;
    }

    public Object run() {
        int totalPendingRecipients;
        int pending = totalPendingRecipients = this.emailPersistenceService.countPendingRecipients();
        int page = 0;
        int sent = 0;
        while (pending > 0) {
            String identifier = Optional.ofNullable(this.identifierModule).orElse(SingularProperties.get().getProperty("singular.mail.module.cod"));
            for (Email.Addressee addressee : this.emailPersistenceService.listPendingRecipients(page * this.emailsPerPage, this.emailsPerPage, identifier)) {
                if (!this.emailSender.send(addressee)) continue;
                this.emailPersistenceService.markAsSent(addressee);
                ++sent;
            }
            pending -= this.emailsPerPage;
            ++page;
        }
        this.getLogger().info("{} sent from total of {}", (Object)sent, (Object)totalPendingRecipients);
        return sent + " sent from total of " + totalPendingRecipients;
    }

    public void setEmailsPerPage(int emailsPerPage) {
        this.emailsPerPage = emailsPerPage;
    }

    public String getId() {
        return "EmailSender";
    }

    public String toString() {
        return "EmailSenderScheduledJob [getScheduleData()=" + this.getScheduleData() + ", getId()=" + this.getId() + "]";
    }
}

