/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.pdf;

import com.itextpdf.text.DocumentException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.app.commons.pdf.PServerFreeMarkerUtil;
import org.opensingular.lib.commons.dto.HtmlToPdfDTO;
import org.opensingular.lib.commons.pdf.HtmlToPdfConverter;
import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class FlyingSaucerConverter
implements HtmlToPdfConverter {
    private boolean showPageNumber;
    private String pageLabel = "P\u00e1gina";
    private String ofLabel = "de";

    public FlyingSaucerConverter() {
        this.showPageNumber = true;
    }

    public FlyingSaucerConverter(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public void setPageLabel(String pageLabel) {
        this.pageLabel = pageLabel;
    }

    public void setOfLabel(String ofLabel) {
        this.ofLabel = ofLabel;
    }

    public Optional<File> convert(HtmlToPdfDTO htmlToPdfDTO) {
        InputStream in = this.convertStream(htmlToPdfDTO);
        if (in != null) {
            return Optional.ofNullable(this.convertHtmlToPdf(in));
        }
        return Optional.empty();
    }

    private File convertHtmlToPdf(InputStream in) {
        String content = this.readFromInputStream(in);
        try {
            Path path = Files.createTempFile(FlyingSaucerConverter.generateFileName(), ".pdf", new FileAttribute[0]);
            if (this.createPdfFile(in, content, path)) {
                return path.toFile();
            }
        }
        catch (IOException e) {
            this.getLogger().error("N\u00e3o foi possivel criar o arquivo temporario", (Throwable)e);
        }
        return null;
    }

    private boolean createPdfFile(InputStream in, String content, Path path) {
        block10: {
            boolean bl;
            block9: {
                OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    ITextRenderer renderer = new ITextRenderer();
                    renderer.setDocumentFromString(content);
                    renderer.layout();
                    renderer.createPDF(out);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    bl = true;
                    if (out == null) break block9;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out != null) {
                                FlyingSaucerConverter.$closeResource(throwable, out);
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException ex) {
                        this.getLogger().error("N\u00e3o foi possivel escrever o arquivo temporario", (Throwable)ex);
                        break block10;
                    }
                    catch (DocumentException e) {
                        this.getLogger().error("Problema na gera\u00e7\u00e3o de PDF", (Throwable)e);
                    }
                }
                FlyingSaucerConverter.$closeResource(throwable, out);
            }
            return bl;
        }
        return false;
    }

    private static String generateFileName() {
        return String.format("singular-fs-html2pdf-%s.pdf", UUID.randomUUID());
    }

    private String readFromInputStream(InputStream inputStream) {
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append('\n');
            }
        }
        catch (IOException e) {
            this.getLogger().error("Erro ao ler InputStream", (Throwable)e);
        }
        return resultStringBuilder.toString();
    }

    public InputStream convertStream(HtmlToPdfDTO htmlToPdfDTO) {
        return new ByteArrayInputStream(this.getPagehtml(htmlToPdfDTO).getBytes(StandardCharsets.UTF_8));
    }

    private String getPagehtml(HtmlToPdfDTO htmlToPdfDTO) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)htmlToPdfDTO.getHeader()) || StringUtils.isNotEmpty((CharSequence)htmlToPdfDTO.getFooter())) {
                this.getLogger().warn("The contents of the HtmlToPdfDTO's header and footer are ignored in the final PDF file.");
            }
            String body = "<div id=\"flying-saucer-body\">" + htmlToPdfDTO.getBody() + "</div>";
            return this.formatHtml(this.getPageNumberHtml() + body);
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error("Erro ao formatar html", (Throwable)e);
            return "";
        }
    }

    private String getPageNumberHtml() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("showPageNumber", this.showPageNumber ? "block" : "none");
        map.put("page", this.pageLabel);
        map.put("of", this.ofLabel);
        return PServerFreeMarkerUtil.mergeWithFreemarker("FlyingSaucerTemplatePage.ftl", map);
    }

    private String formatHtml(String data) throws UnsupportedEncodingException {
        Tidy tidy = new Tidy();
        tidy.setWraplen(Integer.MAX_VALUE);
        tidy.setXmlOut(true);
        tidy.setSmartIndent(true);
        tidy.setCharEncoding(3);
        tidy.setWrapScriptlets(true);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        tidy.parseDOM((InputStream)inputStream, (OutputStream)outputStream);
        return outputStream.toString(StandardCharsets.UTF_8.displayName());
    }
}

