/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.pdf;

import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Version;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.opensingular.form.SInstance;
import org.opensingular.form.SingularFormException;
import org.opensingular.form.internal.freemarker.FormObjectWrapper;
import org.opensingular.lib.commons.context.SingularContext;
import org.opensingular.lib.commons.context.SingularSingletonStrategy;
import org.opensingular.lib.commons.util.Loggable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;

public class PServerFreeMarkerUtil
implements Loggable {
    private static final Version VERSION = Configuration.VERSION_2_3_22;
    private final Configuration cfg = new Configuration(VERSION);
    private final Logger LOGGER = LoggerFactory.getLogger(PServerFreeMarkerUtil.class);

    public void buildConfiguration(Consumer<Configuration> configurationConsumer) {
        this.cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Thread.currentThread().getContextClassLoader(), "templates"));
        this.cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
        if (configurationConsumer != null) {
            configurationConsumer.accept(this.cfg);
        }
    }

    private PServerFreeMarkerUtil() {
        this.buildConfiguration(null);
    }

    private PServerFreeMarkerUtil(Consumer<Configuration> configurationConsumer) {
        this.buildConfiguration(configurationConsumer);
    }

    public static PServerFreeMarkerUtil getInstance() {
        return (PServerFreeMarkerUtil)((SingularSingletonStrategy)SingularContext.get()).singletonize(PServerFreeMarkerUtil.class, PServerFreeMarkerUtil::new);
    }

    public static PServerFreeMarkerUtil getNewInstance(Consumer<Configuration> configurationConsumer) {
        return new PServerFreeMarkerUtil(configurationConsumer);
    }

    public static String mergeWithFreemarker(String templateName, Map<String, Object> model) {
        return PServerFreeMarkerUtil.getInstance().doMergeWithFreemarker(templateName, model);
    }

    public String doMergeWithFreemarker(String templateName, Map<String, Object> model) {
        if (model == null || templateName == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        Predicate<Map.Entry> isInstance = entry -> Optional.ofNullable(entry).map(Map.Entry::getValue).map(Object::getClass).map(SInstance.class::isAssignableFrom).orElse(Boolean.FALSE);
        Map instances = model.entrySet().stream().filter(isInstance).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
        Map pojos = model.entrySet().stream().filter(isInstance.negate()).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
        Map map = (Map)new ObjectMapper().convertValue((Object)pojos, Map.class);
        map.putAll(instances);
        try {
            this.cfg.getTemplate(templateName).process(this.encode(map), (Writer)sw, (ObjectWrapper)new FormObjectWrapper(false));
        }
        catch (Exception ex) {
            this.LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new SingularFormException("N\u00e3o foi possivel fazer o merge do template " + templateName, (Throwable)ex);
        }
        return sw.toString();
    }

    private Object encode(Object o) {
        HashMap m = new HashMap();
        if (!(o instanceof Map)) {
            if (o instanceof String) {
                return HtmlUtils.htmlEscape((String)((String)o));
            }
            if (o instanceof Collection) {
                ArrayList list = new ArrayList();
                ((Collection)o).forEach(x -> list.add(this.encode(x)));
                return list;
            }
            return o;
        }
        ((Map)o).forEach((k, v) -> m.put(k, this.encode(v)));
        return m;
    }
}

