/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence;

import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.opensingular.app.commons.spring.persistence.database.H2DropAllObjectsPopulator;
import org.opensingular.app.commons.spring.persistence.database.PersistenceConfigurationProvider;
import org.opensingular.app.commons.spring.persistence.database.SingularDataBasePopulator;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.persistence.SingularEntityInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement(proxyTargetClass=true)
public class SingularPersistenceDefaultBeanFactory
implements Loggable {
    private PersistenceConfigurationProvider persistenceConfigurationProvider;

    @Bean
    public DataSource dataSource() {
        return this.getPersistenceConfiguration().getDataSource();
    }

    @Bean
    public DataSourceInitializer dataSourceInitializer(DataSource dataSource) {
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(dataSource);
        dataSourceInitializer.setDatabasePopulator((DatabasePopulator)new H2DropAllObjectsPopulator(dataSource));
        dataSourceInitializer.setEnabled(this.getPersistenceConfiguration().isDropAllH2());
        return dataSourceInitializer;
    }

    @Bean
    @DependsOn(value={"dataSourceInitializer"})
    public DataSourceInitializer dataBasePopulator(DataSource dataSource) {
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(dataSource);
        dataSourceInitializer.setDatabasePopulator((DatabasePopulator)new SingularDataBasePopulator(this.getPersistenceConfiguration()));
        dataSourceInitializer.setEnabled(this.getPersistenceConfiguration().isCreateDrop());
        return dataSourceInitializer;
    }

    @Bean
    @DependsOn(value={"dataBasePopulator"})
    public LocalSessionFactoryBean sessionFactory(DataSource dataSource) {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource(dataSource);
        sessionFactoryBean.setHibernateProperties(this.getPersistenceConfiguration().getHibernateProperties());
        sessionFactoryBean.setPackagesToScan(this.getPersistenceConfiguration().getPackagesToScan(true));
        sessionFactoryBean.setEntityInterceptor((Interceptor)new SingularEntityInterceptor(this.getPersistenceConfiguration().getSchemaReplacements()));
        return sessionFactoryBean;
    }

    @Bean
    public HibernateTransactionManager transactionManager(SessionFactory sessionFactory, DataSource dataSource) {
        HibernateTransactionManager tx = new HibernateTransactionManager(sessionFactory);
        tx.setDataSource(dataSource);
        return tx;
    }

    protected PersistenceConfigurationProvider getPersistenceConfiguration() {
        if (this.persistenceConfigurationProvider == null) {
            this.persistenceConfigurationProvider = new PersistenceConfigurationProvider();
        }
        return this.persistenceConfigurationProvider;
    }
}

