/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.database;

import javax.naming.NamingException;
import javax.sql.DataSource;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.Loggable;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jndi.JndiTemplate;

public class DefaultJNDIDataSource
extends DelegatingDataSource
implements Loggable {
    public DataSource getTargetDataSource() {
        if (super.getTargetDataSource() == null) {
            this.setTargetDataSource(this.jndiDataSourceConfiguration());
        }
        return super.getTargetDataSource();
    }

    protected DataSource jndiDataSourceConfiguration() {
        this.getLogger().info("Usando datasource configurado via JNDI");
        DataSource dataSource = null;
        JndiTemplate jndi = new JndiTemplate();
        String dataSourceName = SingularProperties.get((String)"singular.datasource.jndi.name", (String)"java:jboss/datasources/singular");
        try {
            dataSource = (DataSource)jndi.lookup(dataSourceName);
        }
        catch (NamingException e) {
            this.getLogger().error(String.format("Datasource %s not found.", dataSourceName), (Throwable)e);
        }
        return dataSource;
    }
}

