/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.schedule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.schedule.IScheduleData;
import org.opensingular.schedule.IScheduledJob;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionalScheduledJobProxy
implements IScheduledJob {
    private IScheduledJob job;

    public TransactionalScheduledJobProxy(IScheduledJob job) {
        this.job = job;
    }

    public IScheduleData getScheduleData() {
        return this.job.getScheduleData();
    }

    public Object run() {
        return new TransactionTemplate((PlatformTransactionManager)ApplicationContextProvider.get().getBean(PlatformTransactionManager.class)).execute(status -> this.job.run());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String nameBean = ApplicationContextProvider.getBeanName((Object)this.job);
        if (nameBean != null) {
            out.writeObject(nameBean);
        } else {
            out.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object value = in.readObject();
        this.job = value instanceof String ? (IScheduledJob)ApplicationContextProvider.get().getBean((String)value) : (IScheduledJob)value;
    }

    public String getId() {
        return this.job.getId();
    }
}

