/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.database;

import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.h2.Driver;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public class DefaultH2DataSource
extends DelegatingDataSource
implements Loggable {
    public static final String INIT = "INIT";
    private Map<String, String> options = new HashMap<String, String>();
    private String jdbcURL;

    public DefaultH2DataSource(String jdbcURL) {
        this.jdbcURL = jdbcURL;
        this.addToInit("CREATE SCHEMA if not exists DBSINGULAR;");
        this.setAutoServer(true);
        this.setCacheSize(4096);
        this.setMultiThreaded(true);
        this.setMode("ORACLE");
        this.setLockTimeout(15000);
    }

    public DefaultH2DataSource() {
        this("jdbc:h2:file:./singulardb");
    }

    protected String getJdbcUrl() {
        StringBuilder renderedOptions = new StringBuilder();
        for (Map.Entry<String, String> opt : this.options.entrySet()) {
            renderedOptions.append(opt.getKey()).append('=').append(this.escapeSemiColons(opt.getValue())).append(';');
        }
        if (!this.jdbcURL.endsWith(";") && renderedOptions.length() > 0) {
            this.jdbcURL = this.jdbcURL + ";";
        }
        return this.jdbcURL + renderedOptions.toString();
    }

    public DefaultH2DataSource addToInit(String sqlToAppend) {
        this.addToInit(sqlToAppend, true);
        return this;
    }

    public String getInitScript() {
        return this.options.get(INIT);
    }

    private void addToInit(String sqlToAppend, boolean appendToEnd) {
        StringBuilder sb = new StringBuilder();
        sb.append(sqlToAppend);
        if (!sqlToAppend.endsWith(";")) {
            sb.append(';');
        }
        if (appendToEnd) {
            sb.insert(0, StringUtils.defaultString((String)this.options.get(INIT)));
        } else {
            sb.append(StringUtils.defaultString((String)this.options.get(INIT)));
        }
        this.options.put(INIT, sb.toString());
    }

    protected String escapeSemiColons(String sqlToEscape) {
        return sqlToEscape.replaceAll(";", "\\\\;");
    }

    public DefaultH2DataSource setAutoServer(boolean autoServer) {
        if (autoServer) {
            this.options.put("AUTO_SERVER", "TRUE");
        } else {
            this.options.put("AUTO_SERVER", "FALSE");
        }
        return this;
    }

    public DefaultH2DataSource setCloseOnExit(boolean closeOnExit) {
        if (closeOnExit) {
            this.options.put("DB_CLOSE_ON_EXIT", "TRUE");
        } else {
            this.options.put("DB_CLOSE_ON_EXIT", "FALSE");
        }
        return this;
    }

    public DefaultH2DataSource setMultiThreaded(boolean multiThreaded) {
        if (multiThreaded) {
            this.options.put("MULTI_THREADED", "1");
        } else {
            this.options.put("MULTI_THREADED", "FALSE");
        }
        return this;
    }

    public DefaultH2DataSource setCacheSize(int cacheSize) {
        this.options.put("CACHE_SIZE", String.valueOf(cacheSize));
        return this;
    }

    public DefaultH2DataSource setDbCloseDelay(int closeDelay) {
        this.options.put("DB_CLOSE_DELAY", String.valueOf(closeDelay));
        return this;
    }

    public DefaultH2DataSource setLockTimeout(int lockTimeout) {
        this.options.put("LOCK_TIMEOUT", String.valueOf(lockTimeout));
        return this;
    }

    public DefaultH2DataSource setMode(String mode) {
        this.options.put("MODE", mode);
        return this;
    }

    public DataSource getTargetDataSource() {
        if (super.getTargetDataSource() == null) {
            this.setTargetDataSource(this.embeddedDataSourceConfiguration());
        }
        return super.getTargetDataSource();
    }

    protected DataSource embeddedDataSourceConfiguration() {
        try {
            this.getLogger().warn("Using h2 embbeded data source");
            HikariDataSource dataSource = new HikariDataSource();
            String jdbcURL = this.getJdbcUrl();
            this.getLogger().info("H2 CONNECTION URL: {}", (Object)jdbcURL);
            dataSource.setJdbcUrl(jdbcURL);
            dataSource.setUsername("sa");
            dataSource.setPassword("sa");
            dataSource.setDriverClassName(Driver.class.getName());
            return dataSource;
        }
        catch (Exception e) {
            throw SingularException.rethrow((String)e.getMessage(), (Throwable)e);
        }
    }
}

