/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.opensingular.app.commons.spring.persistence.database.DefaultH2DataSource;
import org.opensingular.lib.commons.util.Loggable;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptException;

public class H2DropAllObjectsPopulator
implements DatabasePopulator,
Loggable {
    private final String initScript;

    public H2DropAllObjectsPopulator(DataSource dataSource) {
        this.initScript = dataSource instanceof DefaultH2DataSource ? ((DefaultH2DataSource)((Object)dataSource)).getInitScript() : "";
    }

    public void populate(Connection connection) throws SQLException, ScriptException {
        try (PreparedStatement drop = connection.prepareStatement("DROP ALL OBJECTS");
             PreparedStatement ps = connection.prepareStatement(this.initScript);){
            this.getLogger().warn("DROPPING EMBBEDED H2 DATABASE, SQL: DROP ALL OBJECTS");
            drop.execute();
            this.getLogger().warn("REEXECUTING EMBBEDED H2 DATABASE INIT SCRIPTS");
            ps.execute();
        }
    }
}

