/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.database;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.opensingular.app.commons.spring.persistence.database.SingularDataBaseSuport;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.support.persistence.SingularOracle10gDialect;

public enum SingularDataBaseEnum implements SingularDataBaseSuport
{
    ORACLE(SingularOracle10gDialect.class, "db/ddl/oracle/create-table-actor.sql", "db/ddl/oracle/create-quartz.sql", "db/ddl/oracle/create-function.sql"),
    MSSQL(SQLServer2008Dialect.class, "db/ddl/sqlserver/create-table-actor.sql", "db/ddl/sqlserver/create-quartz.sql", "db/ddl/sqlserver/create-function.sql"),
    H2(H2Dialect.class, "db/ddl/h2/create-table-actor.sql", "db/ddl/h2/create-quartz.sql", "db/ddl/h2/create-function.sql"),
    PGSQL(PostgreSQL9Dialect.class, "db/ddl/postgres/create-table-actor.sql", "db/ddl/postgres/create-quartz.sql", "db/ddl/postgres/create-function.sql");

    private String actorScript;
    private String quartzScript;
    private List<String> scripts;
    private Class<? extends Dialect> dialect;

    private SingularDataBaseEnum(Class<? extends Dialect> dialect, String defaultActorScript, String quartzScript, String ... scripts) {
        this.dialect = dialect;
        this.actorScript = defaultActorScript;
        this.quartzScript = quartzScript;
        this.scripts = Arrays.asList(scripts);
    }

    @Override
    public List<String> getScripts() {
        return this.scripts;
    }

    public boolean isDialectSupported(Class<? extends Dialect> dialect) {
        return this.dialect.isAssignableFrom(dialect);
    }

    @Override
    public String getDefaultActorScript() {
        return this.actorScript;
    }

    @Override
    public String getQuartzScript() {
        return this.quartzScript;
    }

    public static SingularDataBaseSuport getForDialect(Class<? extends Dialect> hibernateDialect) {
        for (SingularDataBaseEnum singularDataBaseEnum : SingularDataBaseEnum.values()) {
            if (!singularDataBaseEnum.isDialectSupported(hibernateDialect)) continue;
            return singularDataBaseEnum;
        }
        throw new SingularException(String.format("Database dialect %s not supported.", hibernateDialect));
    }
}

