/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.database;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.opensingular.app.commons.spring.persistence.database.ExportScriptGenerationException;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.lib.commons.util.Loggable;

public class SingularSchemaExport
implements Loggable {
    private SingularSchemaExport() {
    }

    public static void generateScriptToFile(String[] packages, Class<? extends Dialect> dialect, List<String> scriptsPath, String directoryFileName) {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(directoryFileName), StandardCharsets.UTF_8));){
            writer.write(SingularSchemaExport.generateScript(packages, dialect, scriptsPath).toString());
        }
        catch (Exception e) {
            throw new ExportScriptGenerationException(e.getMessage(), e);
        }
    }

    public static StringBuilder generateScript(String[] packages, Class<? extends Dialect> dialect, List<String> scriptsPath) {
        StringBuilder scriptsText = SingularSchemaExport.readScriptsContent(scriptsPath);
        try {
            Set typesAnnotatedWith = SingularClassPathScanner.get().findClassesAnnotatedWith(Entity.class);
            List list = typesAnnotatedWith.stream().filter(t -> SingularSchemaExport.filterPackages(t, packages)).collect(Collectors.toList());
            MetadataSources metadata = new MetadataSources((ServiceRegistry)new StandardServiceRegistryBuilder().applySetting("hibernate.dialect", (Object)(dialect != null ? dialect.getName() : H2Dialect.class.getName())).applySetting("hibernate.id.new_generator_mappings", (Object)"false").build());
            for (Class c : list) {
                metadata.addAnnotatedClass(c);
            }
            SchemaExport schemaExport = new SchemaExport();
            schemaExport.setOutputFile("db/ddl/scripts.sql");
            schemaExport.createOnly(EnumSet.of(TargetType.SCRIPT), metadata.buildMetadata());
            String[] scriptsEntities = SingularSchemaExport.readFile("db/ddl/scripts.sql").split("\n");
            return SingularSchemaExport.formatterScript(scriptsEntities, scriptsText);
        }
        catch (Exception e) {
            throw new ExportScriptGenerationException(e.getMessage(), e);
        }
    }

    private static boolean filterPackages(Class<?> t, String[] packages) {
        for (String somePackage : packages) {
            if (!t.getPackage().getName().startsWith(somePackage)) continue;
            return true;
        }
        return false;
    }

    private static StringBuilder readScriptsContent(List<String> scriptsPath) {
        try {
            StringBuilder scriptsText = new StringBuilder();
            if (CollectionUtils.isNotEmpty(scriptsPath)) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                for (String script : scriptsPath) {
                    script = SingularSchemaExport.removeStartingSlash(script);
                    SingularSchemaExport.configureScriptTextByScriptPath(scriptsText, classLoader, script);
                }
            }
            return scriptsText;
        }
        catch (IOException e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    private static void configureScriptTextByScriptPath(StringBuilder scriptsText, ClassLoader classLoader, String scriptPath) throws IOException {
        InputStream stream = classLoader.getResourceAsStream(scriptPath);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                scriptsText.append(line).append('\n');
                line = reader.readLine();
            }
        }
    }

    private static String removeStartingSlash(String script) {
        if (script.startsWith("/")) {
            return script.replaceFirst("/", "");
        }
        return script;
    }

    private static StringBuilder formatterScript(String[] scriptsEntities, StringBuilder scriptsAdicionais) {
        Formatter formatter = FormatStyle.DDL.getFormatter();
        StringBuilder stringSql = new StringBuilder();
        for (String string : scriptsEntities) {
            String lineFormated = formatter.format(string) + "; \n";
            stringSql.append(lineFormated);
        }
        if (scriptsAdicionais != null) {
            stringSql.append((CharSequence)scriptsAdicionais);
        }
        return stringSql;
    }

    private static String readFile(String path) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        byte[] encoded = Files.readAllBytes(filePath);
        String s = new String(encoded, Charset.forName("UTF-8"));
        Files.delete(filePath);
        return s;
    }
}

