/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.cache;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.opensingular.app.commons.cache.SingularKeyGenerator;
import org.opensingular.lib.commons.util.Loggable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SingularRequestKeyGenerator
extends SingularKeyGenerator
implements Loggable {
    public static final String SINGULAR_REQUEST_KEY_GENERATOR = "singularRequestKeyGenerator";
    private static final String CACHE_KEYS_ATTRIBUTE_NAME = "#SINGULAR#CACHE#KEYS";

    public static Optional<Set<String>> extractCacheKeysFrom(HttpServletRequest request) {
        return Optional.ofNullable((Set)request.getAttribute(CACHE_KEYS_ATTRIBUTE_NAME));
    }

    @Override
    protected String internalGenerateKey(String methodName, String methodReturnType, String[] parameters, Object[] params) {
        String generatedKey = super.internalGenerateKey(methodName, methodReturnType, parameters, params);
        HttpServletRequest httpServletRequest = this.lookupRequest();
        if (httpServletRequest != null) {
            generatedKey = SingularRequestKeyGenerator.getRequestCachePrefix(httpServletRequest) + generatedKey;
            HashSet<String> cacheKeys = new HashSet<String>();
            SingularRequestKeyGenerator.extractCacheKeysFrom(httpServletRequest).ifPresent(cacheKeys::addAll);
            cacheKeys.add(generatedKey);
            httpServletRequest.setAttribute(CACHE_KEYS_ATTRIBUTE_NAME, cacheKeys);
        }
        return generatedKey;
    }

    private HttpServletRequest lookupRequest() {
        try {
            return Optional.of(RequestContextHolder.currentRequestAttributes()).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest).orElse(null);
        }
        catch (IllegalStateException e) {
            this.getLogger().debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getRequestCachePrefix(HttpServletRequest reqId) {
        return "request#" + Thread.currentThread().getId() + "#";
    }
}

