/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.cache;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.request.cycle.RequestCycle;
import org.opensingular.app.commons.cache.SingularKeyGenerator;

public class SingularSessionKeyGenerator
extends SingularKeyGenerator {
    public static final String SINGULAR_SESSION_KEY_GENERATOR = "singularSessionKeyGenerator";
    private static final String CACHE_KEYS_ATTRIBUTE_NAME = "#SINGULAR#CACHE#KEYS";

    public static Optional<Set<String>> extractCacheKeysFrom(HttpSession session) {
        return Optional.ofNullable((Set)session.getAttribute(CACHE_KEYS_ATTRIBUTE_NAME));
    }

    @Override
    protected String internalGenerateKey(String methodName, String methodReturnType, String[] parameters, Object[] params) {
        String generatedKey = super.internalGenerateKey(methodName, methodReturnType, parameters, params);
        if (RequestCycle.get() != null) {
            HttpSession httpSession = this.lookupSession();
            generatedKey = SingularSessionKeyGenerator.getSessionCachePrefix(httpSession.getId()) + generatedKey;
            HashSet<String> cacheKeys = new HashSet<String>();
            SingularSessionKeyGenerator.extractCacheKeysFrom(httpSession).ifPresent(cacheKeys::addAll);
            cacheKeys.add(generatedKey);
            httpSession.setAttribute(CACHE_KEYS_ATTRIBUTE_NAME, cacheKeys);
        }
        return generatedKey;
    }

    private HttpSession lookupSession() {
        return ((HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest()).getSession();
    }

    public static String getSessionCachePrefix(String sessionId) {
        return "session#" + sessionId + "#";
    }
}

