/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.cache;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import org.opensingular.app.commons.cache.SingularRequestKeyGenerator;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

@WebListener
public class WicketRequestCacheHttpRequestListener
implements ServletRequestListener,
Loggable {
    public void requestDestroyed(ServletRequestEvent sre) {
        if (ApplicationContextProvider.isConfigured() && sre.getServletRequest() instanceof HttpServletRequest) {
            try {
                HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
                CacheManager manager = (CacheManager)ApplicationContextProvider.get().getBean(CacheManager.class);
                Cache cache = manager.getCache("httpRequestCache");
                if (cache != null) {
                    SingularRequestKeyGenerator.extractCacheKeysFrom(request).ifPresent(cacheKeys -> cacheKeys.forEach(arg_0 -> ((Cache)cache).evict(arg_0)));
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }
}

