/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.cache;

import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.opensingular.app.commons.cache.SingularSessionKeyGenerator;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

@WebListener
public class WicketSessionCacheHttpSessionListener
implements HttpSessionListener,
Loggable {
    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        if (ApplicationContextProvider.isConfigured()) {
            try {
                CacheManager manager = (CacheManager)ApplicationContextProvider.get().getBean(CacheManager.class);
                Cache cache = manager.getCache("wicketSession");
                if (cache != null) {
                    SingularSessionKeyGenerator.extractCacheKeysFrom(se.getSession()).ifPresent(cacheKeys -> cacheKeys.forEach(arg_0 -> ((Cache)cache).evict(arg_0)));
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                this.getLogger().warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

