/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.jobs;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.form.persistence.service.AttachmentPersistenceService;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.schedule.IScheduleData;
import org.opensingular.schedule.IScheduledJob;

public class AttachmentGCJob
implements IScheduledJob,
Loggable {
    @Inject
    @Named(value="filePersistence")
    private AttachmentPersistenceService<AttachmentEntity, AttachmentContentEntity> persistenceHandler;
    private IScheduleData scheduleData;

    public AttachmentGCJob(IScheduleData scheduleData) {
        this.scheduleData = scheduleData;
    }

    public IScheduleData getScheduleData() {
        return this.scheduleData;
    }

    public Object run() {
        List orphanAttachments = this.persistenceHandler.listOldOrphanAttachments();
        long failed = 0L;
        for (AttachmentEntity attachment : orphanAttachments) {
            try {
                this.persistenceHandler.deleteAttachmentAndContent(attachment);
            }
            catch (Exception e) {
                this.getLogger().error(String.format("Failed to delete attachment with id: %s", attachment.getCod()), (Throwable)e);
                ++failed;
            }
        }
        String msg = String.format("Removed %d old orphan attachments from %d total.", (long)orphanAttachments.size() - failed, orphanAttachments.size());
        this.getLogger().info(msg);
        return msg;
    }

    public String getId() {
        return "AttachmentGC";
    }

    public String toString() {
        return "AttachmentGCJob [getScheduleData()=" + this.getScheduleData() + ", getId()=" + this.getId() + "]";
    }
}

