/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.persistence.entity.email;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;
import org.opensingular.app.commons.mail.persistence.entity.email.EmailAddresseeEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.lib.support.persistence.entity.BaseEntity;

@Entity
@SequenceGenerator(name="GENERATED_CO_EMAIL", sequenceName="DBSINGULAR.SQ_CO_EMAIL", schema="DBSINGULAR")
@Table(name="TB_EMAIL", schema="DBSINGULAR")
public class EmailEntity
extends BaseEntity<Long> {
    public static final String PK_GENERATOR_NAME = "GENERATED_CO_EMAIL";
    @Id
    @Column(name="CO_EMAIL")
    @GeneratedValue(generator="GENERATED_CO_EMAIL", strategy=GenerationType.AUTO)
    private Long cod;
    @Column(name="TX_RESPONDER_PARA", length=200)
    private String replyTo;
    @Column(name="TX_ASSUNTO", nullable=false, length=200)
    private String subject;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="TX_CONTEUDO", nullable=false)
    private String content;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DT_CRIACAO", nullable=false)
    private Date creationDate;
    @OneToMany(mappedBy="email")
    private List<EmailAddresseeEntity> recipients;
    @OneToMany
    @JoinTable(schema="DBSINGULAR", name="TB_EMAIL_ARQUIVO", uniqueConstraints={@UniqueConstraint(name="UK_EMAIL_ARQUIVO", columnNames={"CO_ARQUIVO"})}, foreignKey=@ForeignKey(name="FK_EMAIL_ARQUIVO_EMAIL"), joinColumns={@JoinColumn(name="CO_EMAIL")}, inverseForeignKey=@ForeignKey(name="FK_EMAIL_ARQUIVO_ARQUIVO"), inverseJoinColumns={@JoinColumn(name="CO_ARQUIVO")})
    private List<AttachmentEntity> attachments = new ArrayList<AttachmentEntity>();
    @Column(name="CO_MODULO", length=30)
    private String module;

    public Long getCod() {
        return this.cod;
    }

    public void setCod(Long cod) {
        this.cod = cod;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public List<EmailAddresseeEntity> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<EmailAddresseeEntity> recipients) {
        this.recipients = recipients;
    }

    public List<AttachmentEntity> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<AttachmentEntity> attachments) {
        this.attachments = attachments;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }
}

