/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.schedule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensingular.app.commons.mail.schedule.SingularSchedulerBean;
import org.opensingular.app.commons.mail.schedule.TransactionalScheduledJobProxy;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.schedule.IScheduledJob;
import org.opensingular.schedule.quartz.QuartzScheduleService;
import org.opensingular.schedule.quartz.SingularQuartzSchedulerAcessor;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class TransactionalQuartzScheduledService
extends QuartzScheduleService
implements Loggable {
    private boolean contextRefreshed;
    private List<IScheduledJob> toBeScheduled = new ArrayList<IScheduledJob>();

    public TransactionalQuartzScheduledService(SingularSchedulerBean singularSchedulerBean) {
        super(false);
        this.setQuartzSchedulerFactory((SingularQuartzSchedulerAcessor)singularSchedulerBean);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public synchronized void initAfterBeans() {
        this.init();
        this.contextRefreshed = true;
        this.toBeScheduled.forEach(this::internalSchedule);
        this.toBeScheduled.clear();
    }

    public synchronized void schedule(IScheduledJob scheduledJob) {
        if (this.contextRefreshed) {
            this.internalSchedule(scheduledJob);
        } else {
            this.toBeScheduled.add(scheduledJob);
        }
    }

    private void internalSchedule(IScheduledJob scheduledJob) {
        super.schedule((IScheduledJob)new TransactionalScheduledJobProxy(scheduledJob));
        this.getLogger().info("Job({}) scheduled.", (Object)scheduledJob);
    }

    public synchronized void deleteJob(IScheduledJob scheduledJob) {
        if (this.contextRefreshed) {
            this.internalDeleteJob(scheduledJob);
        } else {
            Iterator<IScheduledJob> it = this.toBeScheduled.iterator();
            while (it.hasNext()) {
                IScheduledJob job = it.next();
                if (!job.getId().equalsIgnoreCase(scheduledJob.getId())) continue;
                it.remove();
            }
        }
    }

    private void internalDeleteJob(IScheduledJob scheduledJob) {
        super.deleteJob(scheduledJob);
        this.getLogger().info("Job({}) deleted.", (Object)scheduledJob);
    }
}

