/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.mail.service.email;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.opensingular.app.commons.mail.exception.SingularMailException;
import org.opensingular.app.commons.mail.persistence.dao.EmailAddresseeDao;
import org.opensingular.app.commons.mail.persistence.dao.EmailDao;
import org.opensingular.app.commons.mail.persistence.entity.email.EmailAddresseeEntity;
import org.opensingular.app.commons.mail.persistence.entity.email.EmailEntity;
import org.opensingular.app.commons.mail.service.dto.Email;
import org.opensingular.app.commons.mail.service.email.IEmailService;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.form.persistence.service.AttachmentPersistenceService;
import org.opensingular.form.type.core.attachment.IAttachmentRef;
import org.opensingular.form.validation.SingularEmailValidator;
import org.opensingular.lib.commons.base.SingularProperties;

@Transactional(value=Transactional.TxType.MANDATORY)
public class EmailPersistenceService
implements IEmailService<Email> {
    @Inject
    private EmailDao<EmailEntity> emailDao;
    @Inject
    private EmailAddresseeDao<EmailAddresseeEntity> emailAddresseeDao;
    @Inject
    @Named(value="filePersistence")
    private AttachmentPersistenceService<AttachmentEntity, AttachmentContentEntity> persistenceHandler;

    @Override
    public boolean send(Email email) {
        EmailEntity emailEntity = new EmailEntity();
        if (!this.validateRecipients(email.getAllRecipients())) {
            throw new SingularMailException("O destinat\u00e1rio de e-mail \u00e9 inv\u00e1lido.");
        }
        emailEntity.setSubject(email.getSubject());
        emailEntity.setContent(email.getContent());
        emailEntity.setReplyTo(email.getReplyToJoining());
        String emailIdentifier = Optional.ofNullable(email.getModuleCod()).orElse(SingularProperties.get().getPropertyOpt("singular.mail.module.cod").orElse(null));
        emailEntity.setModule(emailIdentifier);
        for (IAttachmentRef attachmentRef : email.getAttachments()) {
            IAttachmentRef attachment = this.persistenceHandler.copy(attachmentRef, null).getNewAttachmentRef();
            emailEntity.getAttachments().add(this.persistenceHandler.getAttachmentEntity(attachment));
        }
        emailEntity.setCreationDate(new Date());
        this.emailDao.save(emailEntity);
        for (Email.Addressee addressee : email.getAllRecipients()) {
            EmailAddresseeEntity addresseeEntity = new EmailAddresseeEntity();
            addresseeEntity.setAddress(addressee.getAddress());
            addresseeEntity.setAddresseType(addressee.getType());
            addresseeEntity.setEmail(emailEntity);
            this.emailAddresseeDao.save(addresseeEntity);
        }
        return true;
    }

    private boolean validateRecipients(List<Email.Addressee> recipients) {
        for (Email.Addressee addressee : recipients) {
            if (SingularEmailValidator.getInstance((boolean)false).isValid(addressee.getAddress())) continue;
            return false;
        }
        return !recipients.isEmpty();
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void markAsSent(Email.Addressee addressee) {
        EmailAddresseeEntity entity = (EmailAddresseeEntity)this.emailAddresseeDao.findOrException(addressee.getCod());
        entity.setSentDate(new Date());
        this.emailAddresseeDao.saveOrUpdate(entity);
        addressee.setSentDate(entity.getSentDate());
    }

    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public int countPendingRecipients() {
        return this.emailAddresseeDao.countPending();
    }

    @org.springframework.transaction.annotation.Transactional(readOnly=true)
    public List<Email.Addressee> listPendingRecipients(int firstResult, int maxResults, @Nullable String codModule) {
        return this.emailAddresseeDao.listPending(firstResult, maxResults).stream().filter(s -> codModule == null || codModule.equals(s.getEmail().getModule())).map(addressee -> {
            Email email = new Email();
            email.withSubject(addressee.getEmail().getSubject());
            email.withContent(addressee.getEmail().getContent());
            email.addReplyTo(addressee.getEmail().getReplyTo());
            email.setCreationDate(addressee.getEmail().getCreationDate());
            for (AttachmentEntity attachmentEntity : addressee.getEmail().getAttachments()) {
                email.addAttachments(new IAttachmentRef[]{this.persistenceHandler.createRef(attachmentEntity)});
            }
            return new Email.Addressee(email, (EmailAddresseeEntity)((Object)addressee));
        }).collect(Collectors.toList());
    }
}

