/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.attachment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.opensingular.form.SingularFormException;
import org.opensingular.form.persistence.dto.AttachmentRef;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.form.persistence.service.AttachmentPersistenceService;

public abstract class ServerAbstractAttachmentPersistenceService<T extends AttachmentEntity, C extends AttachmentContentEntity>
extends AttachmentPersistenceService<T, C> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachmentRef addAttachment(File file, long length, String name, String hash) {
        try (InputStream in = this.getFileInputStream(file);){
            AttachmentRef attachmentRef = this.createRef(this.attachmentDao.insert(in, length, name, hash));
            return attachmentRef;
        }
        catch (Exception e) {
            throw new SingularFormException("Erro lendo origem de dados", (Throwable)e);
        }
    }

    InputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }
}

