/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.attachment;

import java.util.Optional;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.opensingular.app.commons.spring.persistence.attachment.IFormAttachmentService;
import org.opensingular.app.commons.spring.persistence.attachment.ServerAbstractAttachmentPersistenceService;
import org.opensingular.form.document.SDocument;
import org.opensingular.form.persistence.dto.AttachmentRef;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.service.IFormService;
import org.opensingular.form.type.core.attachment.AttachmentCopyContext;
import org.opensingular.form.type.core.attachment.IAttachmentRef;
import org.opensingular.form.type.core.attachment.helper.IAttachmentPersistenceHelper;
import org.opensingular.lib.commons.base.SingularException;

@Transactional
public class ServerAttachmentPersistenceService<T extends AttachmentEntity, C extends AttachmentContentEntity>
extends ServerAbstractAttachmentPersistenceService<T, C> {
    @Inject
    protected transient IFormService formService;
    @Inject
    protected transient IFormAttachmentService formAttachmentService;
    @Inject
    protected transient IAttachmentPersistenceHelper attachmentPersistenceHelper;

    public AttachmentCopyContext<AttachmentRef> copy(IAttachmentRef ref, SDocument sdoc) {
        Optional fve;
        if (!(ref instanceof AttachmentRef)) {
            return super.copy(ref, sdoc);
        }
        if (sdoc != null && (fve = this.formService.findCurrentFormVersion(sdoc)).isPresent()) {
            this.formAttachmentService.saveNewFormAttachmentEntity(this.getAttachmentEntity(ref), (FormVersionEntity)fve.get());
        }
        return new AttachmentCopyContext((IAttachmentRef)((AttachmentRef)ref)).setDeleteOldFiles(false).setUpdateFileId(false);
    }

    public void deleteAttachment(String id, SDocument document) {
        this.formAttachmentService.deleteFormAttachmentEntity(this.getAttachmentEntity(id), (FormVersionEntity)this.formService.findCurrentFormVersion(document).orElseThrow(() -> new SingularException("FormVersion n\u00e3o encontrado")));
    }

    public IAttachmentPersistenceHelper getAttachmentPersistenceHelper() {
        return this.attachmentPersistenceHelper;
    }
}

