/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.database;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.opensingular.app.commons.spring.persistence.database.PackageScanConfiguration;
import org.opensingular.app.commons.spring.persistence.database.SingularDataBaseEnum;
import org.opensingular.app.commons.spring.persistence.database.SingularPersistenceConfiguration;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.persistence.DatabaseObjectNameReplacement;
import org.opensingular.lib.support.persistence.JTDSHibernateDataSourceWrapper;
import org.opensingular.lib.support.persistence.util.SqlUtil;

public class PersistenceConfigurationProvider
implements Loggable {
    protected SingularPersistenceConfiguration persistenceConfiguration;

    public PersistenceConfigurationProvider(SingularPersistenceConfiguration configuration) {
        this.persistenceConfiguration = configuration;
    }

    public PersistenceConfigurationProvider() {
        try {
            Set configs = SingularClassPathScanner.get().findSubclassesOf(SingularPersistenceConfiguration.class);
            if (configs.isEmpty()) {
                throw new SingularException(String.format("Implementation of  %s not found. It is not possible to configure persistence properly.", SingularPersistenceConfiguration.class));
            }
            if (configs.size() > 1) {
                throw new SingularException(String.format("One or more implementation of  %s was found: %s. It is not possible to configure persistence properly.", SingularPersistenceConfiguration.class, Arrays.toString(configs.toArray())));
            }
            this.persistenceConfiguration = (SingularPersistenceConfiguration)((Class)configs.stream().findFirst().get()).newInstance();
        }
        catch (Exception e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    public String[] getPackagesToScan(boolean retrieveAll) {
        PackageScanConfiguration packageScanConfiguration = new PackageScanConfiguration();
        packageScanConfiguration.addPackageToScan("org.opensingular", true);
        packageScanConfiguration.addPackageToScan("com.opensingular", true);
        this.persistenceConfiguration.configureHibernatePackagesToScan(packageScanConfiguration);
        Set<String> packages = retrieveAll ? packageScanConfiguration.getAllPackagesToScan() : packageScanConfiguration.getPackagesToScan();
        return packages.toArray(new String[0]);
    }

    public Properties getHibernateProperties() {
        Properties hibernateProperties = new Properties();
        hibernateProperties.setProperty("hibernate.dialect", this.getDialect().getName());
        hibernateProperties.setProperty("hibernate.connection.isolation", "2");
        hibernateProperties.setProperty("hibernate.jdbc.batch_size", "30");
        hibernateProperties.setProperty("hibernate.show_sql", "false");
        hibernateProperties.setProperty("hibernate.id.new_generator_mappings", "false");
        hibernateProperties.setProperty("hibernate.format_sql", "true");
        hibernateProperties.setProperty("hibernate.enable_lazy_load_no_trans", "true");
        hibernateProperties.setProperty("hibernate.jdbc.use_get_generated_keys", "true");
        hibernateProperties.setProperty("hibernate.cache.use_second_level_cache", "true");
        hibernateProperties.setProperty("hibernate.cache.use_query_cache", "true");
        hibernateProperties.setProperty("hibernate.hbm2ddl.import_files", Joiner.on((String)",").join(this.getSQLScritps()));
        hibernateProperties.setProperty("hibernate.hbm2ddl.import_files_sql_extractor", "org.hibernate.tool.hbm2ddl.MultipleLinesSqlCommandExtractor");
        hibernateProperties.setProperty("net.sf.ehcache.configurationResourceName", "/default-singular-ehcache.xml");
        hibernateProperties.setProperty("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.EhCacheRegionFactory");
        this.persistenceConfiguration.configureHibernateProperties(hibernateProperties);
        return hibernateProperties;
    }

    public List<String> getSQLScritps() {
        ArrayList<String> scripts = new ArrayList<String>();
        if (SqlUtil.useEmbeddedDatabase()) {
            scripts.addAll(SingularDataBaseEnum.H2.getScripts());
        } else {
            scripts.addAll(this.persistenceConfiguration.getDatabaseSupport().getScripts());
        }
        scripts.add(this.persistenceConfiguration.getActorTableScript());
        scripts.add(this.persistenceConfiguration.getDatabaseSupport().getQuartzScript());
        this.persistenceConfiguration.configureInitSQLScripts(scripts);
        return scripts;
    }

    public List<DatabaseObjectNameReplacement> getSchemaReplacements() {
        ArrayList<DatabaseObjectNameReplacement> replacements = new ArrayList<DatabaseObjectNameReplacement>();
        this.persistenceConfiguration.configureQueryReplacements(replacements);
        return replacements;
    }

    public DataSource getDataSource() {
        Object dataSource = SqlUtil.useEmbeddedDatabase() ? this.persistenceConfiguration.getEmbeddedDataSource() : (SingularDataBaseEnum.MSSQL.isDialectSupported(this.getDialect()) ? new JTDSHibernateDataSourceWrapper(this.persistenceConfiguration.getNonEmbeddedDataSource()) : this.persistenceConfiguration.getNonEmbeddedDataSource());
        return dataSource;
    }

    public Class<? extends Dialect> getDialect() {
        return this.persistenceConfiguration.getHibernateDialect();
    }

    public boolean isDropAllH2() {
        return SqlUtil.useEmbeddedDatabase() && this.isCreateDrop();
    }

    public boolean isCreateDrop() {
        return SqlUtil.isDropCreateDatabase();
    }

    public String[] getMappingResources() {
        ArrayList<String> mappings = new ArrayList<String>();
        this.persistenceConfiguration.configuregetMappingResources(mappings);
        return mappings.toArray(new String[0]);
    }
}

