/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.app.commons.spring.persistence.database;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.opensingular.app.commons.spring.persistence.database.PersistenceConfigurationProvider;
import org.opensingular.app.commons.spring.persistence.database.SingularSchemaExport;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.persistence.DatabaseObjectNameReplacement;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptException;

public class SingularDataBasePopulator
extends ResourceDatabasePopulator
implements Loggable {
    private String sqlScriptEncoding;
    private PersistenceConfigurationProvider persistenceConfigurationProvider;

    public SingularDataBasePopulator(@Nonnull PersistenceConfigurationProvider persistenceConfigurationProvider) {
        this.persistenceConfigurationProvider = persistenceConfigurationProvider;
        this.setSqlScriptEncoding(StandardCharsets.UTF_8.name());
        this.setSeparator(";");
    }

    public void populate(Connection connection) throws ScriptException {
        super.addScript((Resource)new ByteArrayResource(this.formattedScriptsToExecute(this.persistenceConfigurationProvider).toString().getBytes(Charset.forName(this.sqlScriptEncoding)), "Singular Schema Export Hibernate DDL + SQL Files"));
        super.populate(connection);
    }

    private StringBuilder formattedScriptsToExecute(PersistenceConfigurationProvider persistenceConfigurationProvider) {
        StringBuilder scripts = SingularSchemaExport.generateScript(persistenceConfigurationProvider.getPackagesToScan(false), persistenceConfigurationProvider.getDialect(), persistenceConfigurationProvider.getSQLScritps());
        for (DatabaseObjectNameReplacement schemaReplacement : persistenceConfigurationProvider.getSchemaReplacements()) {
            Pattern p = Pattern.compile(Pattern.quote(schemaReplacement.getOriginalObjectName()));
            Matcher m = p.matcher(scripts);
            int start = 0;
            while (m.find(start)) {
                scripts.replace(m.start(), m.end(), schemaReplacement.getObjectNameReplacement());
                start = m.start() + schemaReplacement.getObjectNameReplacement().length();
            }
        }
        return scripts;
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
        super.setSqlScriptEncoding(sqlScriptEncoding);
    }
}

