/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.injection;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

public class FieldInjectionInfo {
    private final Field field;
    private final Class<?> fieldType;
    private final String name;
    private final boolean required;
    private final boolean optionalClass;

    public FieldInjectionInfo(@Nonnull Field field) {
        Type optionalType;
        Type gType;
        this.field = field;
        Named named = field.getAnnotation(Named.class);
        this.name = named != null ? StringUtils.trimToNull((String)named.value()) : null;
        Class type = field.getType();
        this.optionalClass = type == Optional.class;
        boolean bl = this.required = !this.optionalClass;
        if (this.optionalClass && (gType = field.getGenericType()) instanceof ParameterizedType && (optionalType = ((ParameterizedType)gType).getActualTypeArguments()[0]) instanceof Class) {
            type = (Class)optionalType;
        }
        this.fieldType = type;
    }

    @Nonnull
    public Field getField() {
        return this.field;
    }

    @Nullable
    public String getBeanName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Nonnull
    public Class<?> getType() {
        return this.fieldType;
    }

    public boolean hasBeanName() {
        return this.name != null;
    }

    public boolean isFieldOptionalBeanReference() {
        return this.optionalClass;
    }

    @Nonnull
    public String getFieldName() {
        return this.field.getName();
    }
}

