/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.injection;

import org.opensingular.internal.lib.commons.injection.FieldInjectionInfo;
import org.opensingular.lib.commons.base.SingularException;

public class SingularInjectionException
extends SingularException {
    public SingularInjectionException(String msg) {
        super(msg);
    }

    public SingularInjectionException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public SingularInjectionException(FieldInjectionInfo fieldInfo, Object target, CharSequence msg, Throwable cause) {
        super(SingularInjectionException.errorMsg(fieldInfo, target, msg), cause);
        if (fieldInfo.getBeanName() != null) {
            this.add("beanName", fieldInfo.getBeanName());
        }
        this.add("targetClass", fieldInfo.getField().getDeclaringClass().getName());
        this.add("fieldName", fieldInfo.getFieldName());
        this.add("fieldClass", fieldInfo.getType().getName());
    }

    private static String errorMsg(FieldInjectionInfo fieldInfo, Object target, CharSequence msg) {
        Class<?> targetClass = target == null ? fieldInfo.getField().getDeclaringClass() : target.getClass();
        StringBuilder msg2 = new StringBuilder("Erro ao tentar injetar o valor no field [").append(targetClass.getSimpleName()).append('.').append(fieldInfo.getFieldName()).append(']');
        if (target != null) {
            msg2.append(" do objeto [").append(target).append(']');
        }
        if (msg != null) {
            msg2.append(": ").append(msg);
        }
        return msg2.toString();
    }
}

