/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.injection;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opensingular.internal.lib.commons.injection.FieldInjectionInfo;
import org.opensingular.internal.lib.commons.injection.SingularFieldValueFactory;
import org.opensingular.internal.lib.commons.injection.SingularInjectionBeanNotFoundException;
import org.opensingular.internal.lib.commons.injection.SingularInjectionException;
import org.opensingular.internal.lib.commons.injection.SingularInjector;

public class SingularInjectorImpl
implements SingularInjector {
    private final ConcurrentMap<Class<?>, FieldInjectionInfo[]> cache = new ConcurrentHashMap();
    private static final FieldInjectionInfo[] EMPTY = new FieldInjectionInfo[0];
    private final SingularFieldValueFactory factory;

    public SingularInjectorImpl(SingularFieldValueFactory factory) {
        this.factory = factory;
    }

    @Override
    public void inject(@Nonnull Object object) {
        Class<?> clazz = object.getClass();
        FieldInjectionInfo[] fields = (FieldInjectionInfo[])this.cache.get(clazz);
        if (fields == null) {
            fields = this.findFields(clazz);
            this.cache.put(clazz, fields);
        }
        for (FieldInjectionInfo fieldInfo : fields) {
            Field field = fieldInfo.getField();
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                if (field.get(object) != null) continue;
                Object value = this.factory.getFieldValue(fieldInfo, object);
                this.setFieldValue(object, fieldInfo, value);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf((Throwable)e, SingularInjectionException.class);
                throw new SingularInjectionException(fieldInfo, object, null, e);
            }
        }
    }

    private void setFieldValue(@Nonnull Object object, FieldInjectionInfo fieldInfo, Object value) throws IllegalAccessException {
        Field field = fieldInfo.getField();
        if (value != null) {
            if (fieldInfo.isFieldOptionalBeanReference()) {
                if (!fieldInfo.getType().isInstance(value)) {
                    throw new SingularInjectionException(fieldInfo, object, " O tipo do Optional incompat\u00edvel. Era esperado ser [" + fieldInfo.getType().getName() + "] mas o bean encontrado \u00e9 do tipo [" + value.getClass().getName() + "]", null);
                }
                field.set(object, Optional.of(value));
            } else {
                field.set(object, value);
            }
        } else {
            if (fieldInfo.isRequired()) {
                throw new SingularInjectionBeanNotFoundException(fieldInfo, object, "N\u00e3o foi encontrado o bean", null);
            }
            if (fieldInfo.isFieldOptionalBeanReference()) {
                field.set(object, Optional.empty());
            }
        }
    }

    @Nonnull
    private FieldInjectionInfo[] findFields(@Nonnull Class<?> clazz) {
        ArrayList<FieldInjectionInfo> matched = new ArrayList<FieldInjectionInfo>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                matched.add(this.factory.createCachedInfo(field));
            }
        }
        return matched.isEmpty() ? EMPTY : matched.toArray(new FieldInjectionInfo[matched.size()]);
    }
}

