/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.injection;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opensingular.internal.lib.commons.injection.FieldInjectionInfo;
import org.opensingular.internal.lib.commons.injection.SingularInjectionNotConfiguredException;
import org.opensingular.internal.lib.commons.injection.SingularInjector;

public abstract class SingularInjectorProxy
implements SingularInjector {
    private static volatile SingularInjectorProxy emptyInjector;
    private volatile SingularInjector singularInjector;
    private Set<Class<?>> verified = new HashSet();

    @Nullable
    protected abstract SingularInjector findInjectorIfAvailable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject(@Nonnull Object object) {
        if (this.singularInjector != null) {
            this.singularInjector.inject(object);
            return;
        }
        this.singularInjector = this.findInjectorIfAvailable();
        if (this.singularInjector != null) {
            this.verified = null;
            this.singularInjector.inject(object);
        } else if (!this.verified.contains(object.getClass())) {
            SingularInjectorProxy singularInjectorProxy = this;
            synchronized (singularInjectorProxy) {
                Class<?> clazz = object.getClass();
                FieldInjectionInfo fieldInfo = this.findInjection(object.getClass());
                if (fieldInfo != null) {
                    throw new SingularInjectionNotConfiguredException(fieldInfo, object);
                }
                this.verified.add(clazz);
            }
        }
    }

    @Nullable
    private FieldInjectionInfo findInjection(@Nonnull Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                return new FieldInjectionInfo(field);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    static SingularInjector getEmptyInjectorImpl() {
        if (emptyInjector != null) return emptyInjector;
        Class<SingularInjectorProxy> clazz = SingularInjectorProxy.class;
        synchronized (SingularInjectorProxy.class) {
            emptyInjector = new SingularInjectorProxy(){

                @Override
                @Nullable
                protected SingularInjector findInjectorIfAvailable() {
                    return null;
                }
            };
            // ** MonitorExit[var0] (shouldn't be in output)
            return emptyInjector;
        }
    }
}

