/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.test;

import com.google.common.base.Throwables;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.opensingular.internal.lib.commons.test.RunnableEx;
import org.opensingular.internal.lib.commons.util.SingularIOUtils;
import org.opensingular.internal.lib.commons.util.TempFileProvider;
import org.opensingular.internal.lib.commons.xml.ConversorToolkit;
import org.opensingular.lib.commons.lambda.IConsumerEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingularTestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingularTestUtil.class);
    public static final int DEFAULT_WAIT_TIME_MILLI_AFTER_SHOW_ON_DESKTOP = 5000;

    private SingularTestUtil() {
    }

    public static void assertException(RunnableEx code, String expectedExceptionMsgPart) {
        SingularTestUtil.assertException(code, RuntimeException.class, expectedExceptionMsgPart, null);
    }

    public static void assertException(RunnableEx code, String expectedExceptionMsgPart, String failMsgIfNoException) {
        SingularTestUtil.assertException(code, RuntimeException.class, expectedExceptionMsgPart, failMsgIfNoException);
    }

    public static void assertException(RunnableEx code, Class<? extends Throwable> expectedException) {
        SingularTestUtil.assertException(code, expectedException, null, null);
    }

    public static void assertException(RunnableEx code, Class<? extends Throwable> expectedException, String expectedExceptionMsgPart) {
        SingularTestUtil.assertException(code, expectedException, expectedExceptionMsgPart, null);
    }

    public static void assertException(@Nonnull RunnableEx code, @Nonnull Class<? extends Throwable> expectedException, @Nullable String expectedExceptionMsgPart, @Nullable String failMsgIfNoException) {
        try {
            code.run();
            String msg = "N\u00e3o ocorreu nenhuma Exception. Era esperado " + expectedException.getSimpleName() + "'";
            if (expectedExceptionMsgPart != null) {
                msg = msg + " com mensagem contendo '" + expectedExceptionMsgPart + "'";
            }
            if (failMsgIfNoException != null) {
                msg = msg + ", pois " + failMsgIfNoException;
            }
            throw new AssertionError((Object)msg);
        }
        catch (Throwable e) {
            if (SingularTestUtil.findExpectedException(e, expectedException, expectedExceptionMsgPart)) {
                return;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            String msg = "Era esperado '" + expectedException.getSimpleName() + "'";
            msg = msg + " no entanto ocorreu a exce\u00e7\u00e3o '" + e.getClass().getSimpleName() + "'";
            throw new AssertionError(msg, e);
        }
    }

    private static boolean findExpectedException(Throwable e, Class<? extends Throwable> expectedException, String expectedExceptionMsgPart) {
        if (expectedException.isInstance(e) && (expectedExceptionMsgPart == null || e.getMessage() != null && e.getMessage().contains(expectedExceptionMsgPart))) {
            return true;
        }
        if (e.getCause() != null) {
            return SingularTestUtil.findExpectedException(e.getCause(), expectedException, expectedExceptionMsgPart);
        }
        return false;
    }

    public static long performance(String testName, int durationInSeconds, Runnable task) {
        long count = 0L;
        long time = System.currentTimeMillis();
        long timeEnd = time + (long)(durationInSeconds * 1000);
        while (System.currentTimeMillis() < timeEnd) {
            for (int i = 0; i < 100; ++i) {
                task.run();
                ++count;
            }
        }
        time = System.currentTimeMillis() - time;
        double resultPerSecond = 1000.0 * (double)count / (double)time;
        System.out.println("-------------------------------------------");
        System.out.println("  " + testName + ": T=" + SingularIOUtils.humanReadableMiliSeconds(time) + " R=" + count + "  qtd/seg=" + ConversorToolkit.printNumber(resultPerSecond, 0));
        return count;
    }

    public static <E extends Exception> void showFileOnDesktopForUserAndWaitOpening(@Nonnull Object requester, @Nonnull String fileExtension, @Nonnull IConsumerEx<OutputStream, E> fileGenerator) {
        SingularTestUtil.showFileOnDesktopForUserAndWaitOpening(requester, fileExtension, fileGenerator, 5000);
    }

    public static <E extends Exception> void showFileOnDesktopForUserAndWaitOpening(@Nonnull Object requester, @Nonnull String fileExtension, @Nonnull IConsumerEx<OutputStream, E> fileGenerator, int waitTimeMilliAfterCall) {
        TempFileProvider.create(requester, tmpProvider -> {
            String ext = fileExtension.indexOf(46) == -1 ? '.' + fileExtension : fileExtension;
            File arq = tmpProvider.createTempFile(ext);
            try (FileOutputStream out = new FileOutputStream(arq);){
                fileGenerator.accept(out);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new SingularTestException(e);
            }
            SingularTestUtil.showFileOnDesktopForUser(arq, waitTimeMilliAfterCall);
        });
    }

    public static void showFileOnDesktopForUserAndWaitOpening(File arq) {
        SingularTestUtil.showFileOnDesktopForUser(arq, 5000);
    }

    public static void showFileOnDesktopForUser(@Nonnull File arq, int waitTimeMilliAfterCall) {
        SingularTestUtil.showFileOnDesktopForUser(arq);
        SingularTestUtil.waitMilli(waitTimeMilliAfterCall);
    }

    public static void showFileOnDesktopForUser(@Nonnull File arq) {
        if (!arq.exists() || arq.isDirectory()) {
            throw new SingularTestException("N\u00e3o existe o arquivo " + arq.getAbsolutePath());
        }
        try {
            Desktop.getDesktop().browse(arq.toURI());
        }
        catch (IOException e) {
            throw new SingularTestException(e);
        }
    }

    public static void waitMilli(int waitTimeMilli) {
        if (waitTimeMilli > 0) {
            try {
                Thread.sleep(waitTimeMilli);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void showHtmlContentOnDesktopForUserAndWaitOpening(@Nonnull String content) {
        SingularTestUtil.showFileOnDesktopForUserAndWaitOpening(SingularTestUtil.class, "html", out -> IOUtils.write((String)content, (OutputStream)out));
    }

    private static class SingularTestException
    extends RuntimeException {
        public SingularTestException() {
        }

        public SingularTestException(String message) {
            super(message);
        }

        public SingularTestException(String message, Throwable cause) {
            super(message, cause);
        }

        public SingularTestException(Throwable cause) {
            super(cause);
        }

        public SingularTestException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

