/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class ConversionUtils {
    private static Pattern HUMANE_NUMBER_PATTERN = Pattern.compile("(\\-?\\s*(?:[0-9][0-9\\.,_]*))\\s*(k|kb|m|mb|g|gb|t|tb|week|weeks|day|days|hour|hours|min|mins|sec|secs|ms)?", 2);
    private static final Map<String, Long> UNIT_MULTIPLIER = new HashMap<String, Long>();

    private ConversionUtils() {
    }

    public static int toIntHumane(String s, int defaultValue) {
        long v = ConversionUtils.toLongHumane(s, defaultValue);
        if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
            return defaultValue;
        }
        return (int)v;
    }

    public static long toLongHumane(String s, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        Matcher m = HUMANE_NUMBER_PATTERN.matcher(s.trim());
        if (!m.matches()) {
            return defaultValue;
        }
        long base = Long.parseLong(m.group(1).replaceAll("[_., ]", ""));
        long multiplier = ConversionUtils.resolveMultiplier(m.group(2));
        return base * multiplier;
    }

    private static long resolveMultiplier(String s) {
        String unit = ((String)StringUtils.defaultIfBlank((CharSequence)s, (CharSequence)"")).toLowerCase();
        Long multiplier = UNIT_MULTIPLIER.get(unit);
        return multiplier != null ? multiplier : 1L;
    }

    static {
        UNIT_MULTIPLIER.put("k", 1024L);
        UNIT_MULTIPLIER.put("kb", 1024L);
        UNIT_MULTIPLIER.put("m", 0x100000L);
        UNIT_MULTIPLIER.put("mb", 0x100000L);
        UNIT_MULTIPLIER.put("g", 0x40000000L);
        UNIT_MULTIPLIER.put("gb", 0x40000000L);
        UNIT_MULTIPLIER.put("t", 0x10000000000L);
        UNIT_MULTIPLIER.put("tb", 0x10000000000L);
        UNIT_MULTIPLIER.put("ms", 1L);
        UNIT_MULTIPLIER.put("sec", 1000L);
        UNIT_MULTIPLIER.put("secs", 1000L);
        UNIT_MULTIPLIER.put("min", 60000L);
        UNIT_MULTIPLIER.put("mins", 60000L);
        UNIT_MULTIPLIER.put("hour", 3600000L);
        UNIT_MULTIPLIER.put("hours", 3600000L);
        UNIT_MULTIPLIER.put("day", 86400000L);
        UNIT_MULTIPLIER.put("days", 86400000L);
        UNIT_MULTIPLIER.put("week", 604800000L);
        UNIT_MULTIPLIER.put("weeks", 604800000L);
    }
}

