/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.internal.lib.commons.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RandomUtil {
    private static final char[] ALL_CHARS = new char[62];
    private static final Random RANDOM = new SecureRandom();

    private RandomUtil() {
    }

    @Nonnull
    public static String generateRandomPassword(int length) {
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = ALL_CHARS[RANDOM.nextInt(ALL_CHARS.length)];
        }
        return String.valueOf(result);
    }

    @Nullable
    public static <T> T selectRandom(Collection<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        int pos = list.size() == 1 ? 0 : RANDOM.nextInt(list.size());
        if (list instanceof ArrayList) {
            return (T)((ArrayList)list).get(pos);
        }
        int i = 0;
        for (T obj : list) {
            if (i == pos) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    static {
        int j = 0;
        for (int i = 48; i < 123; ++i) {
            if (!Character.isLetterOrDigit(i)) continue;
            RandomUtil.ALL_CHARS[j] = (char)i;
            ++j;
        }
    }
}

